/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.fusion;

import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.operators.UnionOperator;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.api.operators.BinaryBaseGraphToBaseGraphOperator;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.IdNotInBroadcast;
import org.gradoop.flink.model.impl.functions.epgm.SourceId;
import org.gradoop.flink.model.impl.functions.epgm.TargetId;
import org.gradoop.flink.model.impl.functions.tuple.Value0Of2;
import org.gradoop.flink.model.impl.functions.tuple.Value1Of2;
import org.gradoop.flink.model.impl.functions.utils.LeftSide;
import org.gradoop.flink.model.impl.operators.fusion.AddNewIdToDuplicatedEdge;
import org.gradoop.flink.model.impl.operators.fusion.functions.CoGroupAssociateOldVerticesWithNewIds;
import org.gradoop.flink.model.impl.operators.fusion.functions.CoGroupGraphHeadToVertex;
import org.gradoop.flink.model.impl.operators.fusion.functions.FlatJoinSourceEdgeReference;
import org.gradoop.flink.model.impl.operators.fusion.functions.LeftElementId;
import org.gradoop.flink.model.impl.operators.fusion.functions.MapFunctionAddGraphElementToGraph2;
import org.gradoop.flink.model.impl.operators.fusion.functions.MapGraphHeadForNewGraph;
import org.gradoop.flink.model.impl.operators.fusion.functions.MapVertexToPairWithGraphId;
import org.gradoop.flink.model.impl.operators.fusion.functions.MapVerticesAsTuplesWithNullId;

public class VertexFusion
implements BinaryBaseGraphToBaseGraphOperator<LogicalGraph> {
    @Override
    public LogicalGraph execute(LogicalGraph searchGraph, LogicalGraph graphPatterns) {
        return this.execute(searchGraph, graphPatterns.getCollectionFactory().fromDataSets(graphPatterns.getGraphHead(), graphPatterns.getVertices(), graphPatterns.getEdges()));
    }

    @Override
    public LogicalGraph execute(LogicalGraph searchGraph, GraphCollection graphPatterns) {
        GradoopId newGraphid = GradoopId.get();
        MapOperator gh = searchGraph.getGraphHead().map((MapFunction)new MapGraphHeadForNewGraph(newGraphid));
        MapOperator patternVertexIds = graphPatterns.getVertices().map(new Id());
        MapOperator patternEdgeIds = graphPatterns.getEdges().map(new Id());
        FlatMapOperator patternVerticesWithGraphIDs = graphPatterns.getVertices().coGroup(searchGraph.getVertices()).where(new Id()).equalTo(new Id()).with(new LeftSide()).flatMap((FlatMapFunction)new MapVertexToPairWithGraphId());
        MapOperator mergedVertices = graphPatterns.getGraphHeads().map((MapFunction)new CoGroupGraphHeadToVertex());
        SingleInputUdfOperator vi = searchGraph.getVertices().filter(new IdNotInBroadcast()).withBroadcastSet((DataSet)patternVertexIds, "IdsNotIn");
        UnionOperator idJoin = patternVerticesWithGraphIDs.coGroup((DataSet)mergedVertices).where(new Value1Of2()).equalTo(new Value1Of2()).with((CoGroupFunction)new CoGroupAssociateOldVerticesWithNewIds()).union((DataSet)vi.map((MapFunction)new MapVerticesAsTuplesWithNullId()));
        MapOperator vToRet = mergedVertices.coGroup((DataSet)patternVerticesWithGraphIDs).where(new Value1Of2()).equalTo(new Value1Of2()).with(new LeftSide()).map(new Value0Of2()).union((DataSet)vi).map(new MapFunctionAddGraphElementToGraph2(newGraphid));
        MapOperator edges = ((FilterOperator)searchGraph.getEdges().filter(new IdNotInBroadcast()).withBroadcastSet((DataSet)patternEdgeIds, "IdsNotIn")).leftOuterJoin((DataSet)idJoin).where(new SourceId()).equalTo(new LeftElementId()).with((FlatJoinFunction)new FlatJoinSourceEdgeReference(true)).leftOuterJoin((DataSet)idJoin).where(new TargetId()).equalTo(new LeftElementId()).with((FlatJoinFunction)new FlatJoinSourceEdgeReference(false)).groupBy(new Id()).reduceGroup((GroupReduceFunction)new AddNewIdToDuplicatedEdge()).map(new MapFunctionAddGraphElementToGraph2(newGraphid));
        return searchGraph.getFactory().fromDataSets((DataSet<EPGMGraphHead>)gh, (DataSet<EPGMVertex>)vToRet, (DataSet<EPGMEdge>)edges);
    }
}

