/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.fusion.functions;

import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMVertex;

public class UpdateEdgesThoughToBeFusedVertices
implements FlatJoinFunction<EPGMEdge, EPGMVertex, EPGMEdge> {
    private static final EPGMEdge REUSABLE_EDGE = new EPGMEdge();
    private GradoopId vId;
    private boolean isSourceNow;

    public UpdateEdgesThoughToBeFusedVertices(GradoopId vId, boolean isSource) {
        this.vId = vId;
        this.isSourceNow = isSource;
    }

    public void join(EPGMEdge edge, EPGMVertex vertex, Collector<EPGMEdge> collector) throws Exception {
        if (vertex == null) {
            collector.collect((Object)edge);
        } else if (edge != null) {
            REUSABLE_EDGE.setId(GradoopId.get());
            REUSABLE_EDGE.setSourceId(this.isSourceNow ? this.vId : edge.getSourceId());
            REUSABLE_EDGE.setTargetId(this.isSourceNow ? edge.getTargetId() : this.vId);
            REUSABLE_EDGE.setProperties(edge.getProperties());
            REUSABLE_EDGE.setLabel(edge.getLabel());
            REUSABLE_EDGE.setGraphIds(edge.getGraphIds());
            collector.collect((Object)REUSABLE_EDGE);
        }
    }
}

