/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.grouping;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.GroupCombineOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.TwoInputUdfOperator;
import org.apache.flink.api.java.operators.UnsortedGrouping;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.functions.AggregateFunction;
import org.gradoop.flink.model.api.operators.UnaryBaseGraphToBaseGraphOperator;
import org.gradoop.flink.model.impl.operators.grouping.GroupingGroupCombine;
import org.gradoop.flink.model.impl.operators.grouping.GroupingGroupReduce;
import org.gradoop.flink.model.impl.operators.grouping.GroupingStrategy;
import org.gradoop.flink.model.impl.operators.grouping.functions.BuildEdgeGroupItem;
import org.gradoop.flink.model.impl.operators.grouping.functions.CombineEdgeGroupItems;
import org.gradoop.flink.model.impl.operators.grouping.functions.ReduceEdgeGroupItems;
import org.gradoop.flink.model.impl.operators.grouping.functions.UpdateEdgeGroupItem;
import org.gradoop.flink.model.impl.operators.grouping.tuples.EdgeGroupItem;
import org.gradoop.flink.model.impl.operators.grouping.tuples.LabelGroup;
import org.gradoop.flink.model.impl.operators.grouping.tuples.VertexGroupItem;
import org.gradoop.flink.model.impl.operators.grouping.tuples.VertexWithSuperVertex;
import org.gradoop.flink.model.impl.operators.keyedgrouping.KeyedGroupingUtils;

public abstract class Grouping<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
implements UnaryBaseGraphToBaseGraphOperator<LG> {
    public static final String LABEL_SYMBOL = ":label";
    public static final String DEFAULT_VERTEX_LABEL_GROUP = ":defaultVertexLabelGroup";
    public static final String DEFAULT_EDGE_LABEL_GROUP = ":defaultEdgeLabelGroup";
    private final boolean useVertexLabels;
    private final boolean useEdgeLabels;
    private final List<LabelGroup> vertexLabelGroups;
    private final List<LabelGroup> edgeLabelGroups;

    Grouping(boolean useVertexLabels, boolean useEdgeLabels, List<LabelGroup> vertexLabelGroups, List<LabelGroup> edgeLabelGroups) {
        this.useVertexLabels = useVertexLabels;
        this.useEdgeLabels = useEdgeLabels;
        this.vertexLabelGroups = vertexLabelGroups;
        this.edgeLabelGroups = edgeLabelGroups;
    }

    @Override
    public LG execute(LG graph) {
        LG result = !this.useVertexProperties() && !this.useEdgeProperties() && !this.useVertexLabels() && !this.useEdgeLabels() ? graph : this.groupInternal(graph);
        return result;
    }

    protected boolean useVertexProperties() {
        return !this.vertexLabelGroups.isEmpty();
    }

    protected boolean useVertexLabels() {
        return this.useVertexLabels;
    }

    protected boolean useEdgeProperties() {
        return !this.edgeLabelGroups.isEmpty();
    }

    protected boolean useEdgeLabels() {
        return this.useEdgeLabels;
    }

    public List<LabelGroup> getVertexLabelGroups() {
        return this.vertexLabelGroups;
    }

    public List<LabelGroup> getEdgeLabelGroups() {
        return this.edgeLabelGroups;
    }

    protected UnsortedGrouping<VertexGroupItem> groupVertices(DataSet<VertexGroupItem> groupVertices) {
        UnsortedGrouping vertexGrouping = this.useVertexLabels() && this.useVertexProperties() ? groupVertices.groupBy(new int[]{2, 3}) : (this.useVertexLabels() ? groupVertices.groupBy(new int[]{2}) : groupVertices.groupBy(new int[]{3}));
        return vertexGrouping;
    }

    protected UnsortedGrouping<EdgeGroupItem> groupEdges(DataSet<EdgeGroupItem> edges) {
        UnsortedGrouping groupedEdges = this.useEdgeProperties() && this.useEdgeLabels() ? edges.groupBy(new int[]{0, 1, 2, 3}) : (this.useEdgeLabels() ? edges.groupBy(new int[]{0, 1, 2}) : (this.useEdgeProperties() ? edges.groupBy(new int[]{0, 1, 3}) : edges.groupBy(new int[]{0, 1})));
        return groupedEdges;
    }

    protected DataSet<E> buildSuperEdges(LG graph, DataSet<VertexWithSuperVertex> vertexToRepresentativeMap) {
        TwoInputUdfOperator edges = ((JoinOperator)((JoinOperator)((JoinOperator)graph.getEdges().flatMap(new BuildEdgeGroupItem(this.useEdgeLabels(), this.getEdgeLabelGroups())).join(vertexToRepresentativeMap).where(new int[]{0}).equalTo(new int[]{0}).with((JoinFunction)new UpdateEdgeGroupItem(0)).withForwardedFieldsFirst(new String[]{"f1;f2;f3;f4"})).withForwardedFieldsSecond(new String[]{"f1->f0"})).join(vertexToRepresentativeMap).where(new int[]{1}).equalTo(new int[]{0}).with((JoinFunction)new UpdateEdgeGroupItem(1)).withForwardedFieldsFirst(new String[]{"f0;f2;f3;f4"})).withForwardedFieldsSecond(new String[]{"f1->f1"});
        GroupCombineOperator combinedEdges = this.groupEdges((DataSet<EdgeGroupItem>)edges).combineGroup((GroupCombineFunction)new CombineEdgeGroupItems(this.useEdgeLabels()));
        return this.groupEdges((DataSet<EdgeGroupItem>)combinedEdges).reduceGroup(new ReduceEdgeGroupItems(this.useEdgeLabels(), graph.getFactory().getEdgeFactory()));
    }

    protected abstract LG groupInternal(LG var1);

    public static final class GroupingBuilder {
        private GroupingStrategy strategy;
        private boolean useVertexLabel = false;
        private boolean useEdgeLabel = false;
        private List<LabelGroup> vertexLabelGroups = new ArrayList<LabelGroup>();
        private List<LabelGroup> edgeLabelGroups = new ArrayList<LabelGroup>();
        private LabelGroup defaultVertexLabelGroup;
        private LabelGroup defaultEdgeLabelGroup;
        private List<AggregateFunction> globalVertexAggregateFunctions = new ArrayList<AggregateFunction>();
        private List<AggregateFunction> globalEdgeAggregateFunctions = new ArrayList<AggregateFunction>();

        public GroupingBuilder() {
            this.defaultVertexLabelGroup = new LabelGroup(Grouping.DEFAULT_VERTEX_LABEL_GROUP, "");
            this.defaultEdgeLabelGroup = new LabelGroup(Grouping.DEFAULT_EDGE_LABEL_GROUP, "");
            this.vertexLabelGroups.add(this.defaultVertexLabelGroup);
            this.edgeLabelGroups.add(this.defaultEdgeLabelGroup);
        }

        public GroupingBuilder setStrategy(GroupingStrategy strategy) {
            Objects.requireNonNull(strategy);
            this.strategy = strategy;
            return this;
        }

        public GroupingBuilder addVertexGroupingKey(String key) {
            Objects.requireNonNull(key);
            if (key.equals(Grouping.LABEL_SYMBOL)) {
                this.useVertexLabel(true);
            } else {
                this.defaultVertexLabelGroup.addPropertyKey(key);
            }
            return this;
        }

        public GroupingBuilder addVertexGroupingKeys(List<String> keys) {
            Objects.requireNonNull(keys);
            for (String key : keys) {
                this.addVertexGroupingKey(key);
            }
            return this;
        }

        public GroupingBuilder addEdgeGroupingKey(String key) {
            Objects.requireNonNull(key);
            if (key.equals(Grouping.LABEL_SYMBOL)) {
                this.useEdgeLabel(true);
            } else {
                this.defaultEdgeLabelGroup.addPropertyKey(key);
            }
            return this;
        }

        public GroupingBuilder addEdgeGroupingKeys(List<String> keys) {
            Objects.requireNonNull(keys);
            for (String key : keys) {
                this.addEdgeGroupingKey(key);
            }
            return this;
        }

        public GroupingBuilder addVertexLabelGroup(String label, List<String> groupingKeys) {
            return this.addVertexLabelGroup(label, label, groupingKeys);
        }

        public GroupingBuilder addVertexLabelGroup(String label, List<String> groupingKeys, List<AggregateFunction> aggregateFunctions) {
            return this.addVertexLabelGroup(label, label, groupingKeys, aggregateFunctions);
        }

        public GroupingBuilder addVertexLabelGroup(String label, String superVertexLabel, List<String> groupingKeys) {
            return this.addVertexLabelGroup(label, superVertexLabel, groupingKeys, new ArrayList<AggregateFunction>());
        }

        public GroupingBuilder addVertexLabelGroup(String label, String superVertexLabel, List<String> groupingKeys, List<AggregateFunction> aggregateFunctions) {
            this.vertexLabelGroups.add(new LabelGroup(label, superVertexLabel, groupingKeys, aggregateFunctions));
            return this;
        }

        public GroupingBuilder addEdgeLabelGroup(String label, List<String> groupingKeys) {
            return this.addEdgeLabelGroup(label, label, groupingKeys);
        }

        public GroupingBuilder addEdgeLabelGroup(String label, List<String> groupingKeys, List<AggregateFunction> aggregateFunctions) {
            return this.addEdgeLabelGroup(label, label, groupingKeys, aggregateFunctions);
        }

        public GroupingBuilder addEdgeLabelGroup(String label, String superEdgeLabel, List<String> groupingKeys) {
            return this.addEdgeLabelGroup(label, superEdgeLabel, groupingKeys, new ArrayList<AggregateFunction>());
        }

        public GroupingBuilder addEdgeLabelGroup(String label, String superEdgeLabel, List<String> groupingKeys, List<AggregateFunction> aggregateFunctions) {
            this.edgeLabelGroups.add(new LabelGroup(label, superEdgeLabel, groupingKeys, aggregateFunctions));
            return this;
        }

        public GroupingBuilder useVertexLabel(boolean useVertexLabel) {
            this.useVertexLabel = useVertexLabel;
            return this;
        }

        public GroupingBuilder useEdgeLabel(boolean useEdgeLabel) {
            this.useEdgeLabel = useEdgeLabel;
            return this;
        }

        public GroupingBuilder addVertexAggregateFunction(AggregateFunction aggregateFunction) {
            Objects.requireNonNull(aggregateFunction, "Aggregate function must not be null");
            this.defaultVertexLabelGroup.addAggregateFunction(aggregateFunction);
            return this;
        }

        public GroupingBuilder addGlobalVertexAggregateFunction(AggregateFunction aggregateFunction) {
            Objects.requireNonNull(aggregateFunction, "Aggregate function must not be null");
            this.globalVertexAggregateFunctions.add(aggregateFunction);
            return this;
        }

        public GroupingBuilder addGlobalEdgeAggregateFunction(AggregateFunction aggregateFunction) {
            Objects.requireNonNull(aggregateFunction, "Aggregate function must not be null");
            this.globalEdgeAggregateFunctions.add(aggregateFunction);
            return this;
        }

        public GroupingBuilder addEdgeAggregateFunction(AggregateFunction aggregateFunction) {
            Objects.requireNonNull(aggregateFunction, "Aggregate function must not be null");
            this.defaultEdgeLabelGroup.addAggregateFunction(aggregateFunction);
            return this;
        }

        public <G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>> UnaryBaseGraphToBaseGraphOperator<LG> build() {
            UnaryBaseGraphToBaseGraphOperator groupingOperator;
            if (this.strategy == null) {
                throw new IllegalStateException("A GroupingStrategy has to be set.");
            }
            if (this.strategy != GroupingStrategy.GROUP_WITH_KEYFUNCTIONS) {
                for (LabelGroup vertexLabelGroup : this.vertexLabelGroups) {
                    for (AggregateFunction aggregateFunction : this.globalVertexAggregateFunctions) {
                        vertexLabelGroup.addAggregateFunction(aggregateFunction);
                    }
                }
                for (LabelGroup edgeLabelGroup : this.edgeLabelGroups) {
                    for (AggregateFunction aggregateFunction : this.globalEdgeAggregateFunctions) {
                        edgeLabelGroup.addAggregateFunction(aggregateFunction);
                    }
                }
            }
            switch (this.strategy) {
                case GROUP_REDUCE: {
                    groupingOperator = new GroupingGroupReduce(this.useVertexLabel, this.useEdgeLabel, this.vertexLabelGroups, this.edgeLabelGroups);
                    break;
                }
                case GROUP_COMBINE: {
                    groupingOperator = new GroupingGroupCombine(this.useVertexLabel, this.useEdgeLabel, this.vertexLabelGroups, this.edgeLabelGroups);
                    break;
                }
                case GROUP_WITH_KEYFUNCTIONS: {
                    groupingOperator = KeyedGroupingUtils.createInstance(this.useVertexLabel, this.useEdgeLabel, this.vertexLabelGroups, this.edgeLabelGroups, this.globalVertexAggregateFunctions, this.globalEdgeAggregateFunctions);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported strategy: " + (Object)((Object)this.strategy));
                }
            }
            return groupingOperator;
        }
    }
}

