/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.grouping;

import java.util.List;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.GroupCombineOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.impl.functions.tuple.Value0Of2;
import org.gradoop.flink.model.impl.functions.tuple.Value1Of2;
import org.gradoop.flink.model.impl.operators.grouping.Grouping;
import org.gradoop.flink.model.impl.operators.grouping.functions.BuildSuperVertex;
import org.gradoop.flink.model.impl.operators.grouping.functions.BuildVertexGroupItem;
import org.gradoop.flink.model.impl.operators.grouping.functions.BuildVertexWithSuperVertexBC;
import org.gradoop.flink.model.impl.operators.grouping.functions.CombineVertexGroupItems;
import org.gradoop.flink.model.impl.operators.grouping.functions.FilterRegularVertices;
import org.gradoop.flink.model.impl.operators.grouping.functions.FilterSuperVertices;
import org.gradoop.flink.model.impl.operators.grouping.functions.TransposeVertexGroupItems;
import org.gradoop.flink.model.impl.operators.grouping.tuples.LabelGroup;
import org.gradoop.flink.model.impl.operators.grouping.tuples.VertexGroupItem;
import org.gradoop.flink.model.impl.operators.grouping.tuples.VertexWithSuperVertex;

public class GroupingGroupCombine<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
extends Grouping<G, V, E, LG, GC> {
    GroupingGroupCombine(boolean useVertexLabels, boolean useEdgeLabels, List<LabelGroup> vertexLabelGroups, List<LabelGroup> edgeLabelGroups) {
        super(useVertexLabels, useEdgeLabels, vertexLabelGroups, edgeLabelGroups);
    }

    @Override
    protected LG groupInternal(LG graph) {
        FlatMapOperator verticesForGrouping = graph.getVertices().flatMap(new BuildVertexGroupItem(this.useVertexLabels(), this.getVertexLabelGroups()));
        GroupCombineOperator combinedVertexGroupItems = this.groupVertices((DataSet<VertexGroupItem>)verticesForGrouping).combineGroup((GroupCombineFunction)new CombineVertexGroupItems(this.useVertexLabels()));
        GroupReduceOperator superVertexTuples = this.groupVertices((DataSet<VertexGroupItem>)combinedVertexGroupItems.filter((FilterFunction)new FilterSuperVertices())).reduceGroup((GroupReduceFunction)new TransposeVertexGroupItems(this.useVertexLabels()));
        MapOperator superVertices = superVertexTuples.map(new Value0Of2()).map(new BuildSuperVertex(this.useVertexLabels(), graph.getFactory().getVertexFactory()));
        MapOperator mapping = superVertexTuples.map(new Value1Of2());
        SingleInputUdfOperator vertexToRepresentativeMap = combinedVertexGroupItems.filter((FilterFunction)new FilterRegularVertices()).map((MapFunction)new BuildVertexWithSuperVertexBC()).withBroadcastSet((DataSet)mapping, "mapping");
        DataSet superEdges = this.buildSuperEdges(graph, (DataSet<VertexWithSuperVertex>)vertexToRepresentativeMap);
        return graph.getFactory().fromDataSets(superVertices, superEdges);
    }
}

