/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.grouping;

import java.util.List;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.impl.operators.grouping.Grouping;
import org.gradoop.flink.model.impl.operators.grouping.functions.BuildSuperVertex;
import org.gradoop.flink.model.impl.operators.grouping.functions.BuildVertexGroupItem;
import org.gradoop.flink.model.impl.operators.grouping.functions.BuildVertexWithSuperVertex;
import org.gradoop.flink.model.impl.operators.grouping.functions.FilterRegularVertices;
import org.gradoop.flink.model.impl.operators.grouping.functions.FilterSuperVertices;
import org.gradoop.flink.model.impl.operators.grouping.functions.ReduceVertexGroupItems;
import org.gradoop.flink.model.impl.operators.grouping.tuples.LabelGroup;
import org.gradoop.flink.model.impl.operators.grouping.tuples.VertexGroupItem;
import org.gradoop.flink.model.impl.operators.grouping.tuples.VertexWithSuperVertex;

public class GroupingGroupReduce<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
extends Grouping<G, V, E, LG, GC> {
    GroupingGroupReduce(boolean useVertexLabels, boolean useEdgeLabels, List<LabelGroup> vertexLabelGroups, List<LabelGroup> edgeLabelGroups) {
        super(useVertexLabels, useEdgeLabels, vertexLabelGroups, edgeLabelGroups);
    }

    @Override
    protected LG groupInternal(LG graph) {
        FlatMapOperator verticesForGrouping = graph.getVertices().flatMap(new BuildVertexGroupItem(this.useVertexLabels(), this.getVertexLabelGroups()));
        GroupReduceOperator vertexGroupItems = this.groupVertices((DataSet<VertexGroupItem>)verticesForGrouping).reduceGroup((GroupReduceFunction)new ReduceVertexGroupItems(this.useVertexLabels()));
        MapOperator superVertices = vertexGroupItems.filter((FilterFunction)new FilterSuperVertices()).map(new BuildSuperVertex(this.useVertexLabels(), graph.getFactory().getVertexFactory()));
        MapOperator vertexToRepresentativeMap = vertexGroupItems.filter((FilterFunction)new FilterRegularVertices()).map((MapFunction)new BuildVertexWithSuperVertex());
        DataSet superEdges = this.buildSuperEdges(graph, (DataSet<VertexWithSuperVertex>)vertexToRepresentativeMap);
        return graph.getFactory().fromDataSets(superVertices, superEdges);
    }
}

