/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.grouping.functions;

import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.flink.model.impl.operators.grouping.functions.BuildGroupItemBase;
import org.gradoop.flink.model.impl.operators.grouping.tuples.EdgeGroupItem;
import org.gradoop.flink.model.impl.operators.grouping.tuples.LabelGroup;

@FunctionAnnotation.ForwardedFields(value={"sourceId->f0;targetId->f1;"})
@FunctionAnnotation.ReadFields(value={"label;properties"})
public class BuildEdgeGroupItem<E extends Edge>
extends BuildGroupItemBase
implements FlatMapFunction<E, EdgeGroupItem> {
    private final EdgeGroupItem reuseEdgeGroupItem = new EdgeGroupItem();

    public BuildEdgeGroupItem(boolean useLabel, List<LabelGroup> edgeLabelGroups) {
        super(useLabel, edgeLabelGroups);
    }

    public void flatMap(E edge, Collector<EdgeGroupItem> collector) throws Exception {
        boolean usedEdgeLabelGroup = false;
        this.reuseEdgeGroupItem.setSourceId(edge.getSourceId());
        this.reuseEdgeGroupItem.setTargetId(edge.getTargetId());
        for (LabelGroup edgeLabelGroup : this.getLabelGroups()) {
            if (!edgeLabelGroup.getGroupingLabel().equals(edge.getLabel())) continue;
            usedEdgeLabelGroup = true;
            this.setGroupItem(this.reuseEdgeGroupItem, (Element)edge, edgeLabelGroup);
            collector.collect((Object)this.reuseEdgeGroupItem);
        }
        if (!usedEdgeLabelGroup) {
            this.setGroupItem(this.reuseEdgeGroupItem, (Element)edge, this.getDefaultLabelGroup());
            collector.collect((Object)this.reuseEdgeGroupItem);
        }
    }
}

