/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.grouping.functions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.common.model.impl.properties.PropertyValueList;
import org.gradoop.flink.model.impl.operators.grouping.functions.BuildBase;
import org.gradoop.flink.model.impl.operators.grouping.tuples.GroupItem;
import org.gradoop.flink.model.impl.operators.grouping.tuples.LabelGroup;

public class BuildGroupItemBase
extends BuildBase {
    private final List<LabelGroup> labelGroups;
    private final LabelGroup defaultLabelGroup;
    private List<PropertyValue> groupingValues;

    public BuildGroupItemBase(boolean useLabel, List<LabelGroup> labelGroups) {
        super(useLabel);
        this.labelGroups = labelGroups;
        this.groupingValues = new ArrayList<PropertyValue>();
        LabelGroup standardLabelGroup = null;
        for (LabelGroup labelGroup : labelGroups) {
            if (labelGroup.getGroupingLabel().equals(":defaultVertexLabelGroup")) {
                standardLabelGroup = labelGroup;
                break;
            }
            if (!labelGroup.getGroupingLabel().equals(":defaultEdgeLabelGroup")) continue;
            standardLabelGroup = labelGroup;
            break;
        }
        this.defaultLabelGroup = standardLabelGroup;
    }

    protected void setGroupItem(GroupItem groupItem, Element element, LabelGroup labelGroup) throws IOException {
        for (String groupPropertyKey : labelGroup.getPropertyKeys()) {
            if (element.hasProperty(groupPropertyKey)) {
                this.groupingValues.add(element.getPropertyValue(groupPropertyKey));
                continue;
            }
            this.groupingValues.add(PropertyValue.NULL_VALUE);
        }
        if (labelGroup.getGroupingLabel().equals(this.getDefaultLabelGroup().getGroupingLabel()) && this.useLabel()) {
            groupItem.setGroupLabel(element.getLabel());
        } else {
            groupItem.setGroupLabel(labelGroup.getGroupLabel());
        }
        groupItem.setAggregateValues(labelGroup.getIncrementValues(element));
        groupItem.setLabelGroup(labelGroup);
        groupItem.setGroupingValues(PropertyValueList.fromPropertyValues(this.groupingValues));
        this.groupingValues.clear();
    }

    protected List<LabelGroup> getLabelGroups() {
        return this.labelGroups;
    }

    protected LabelGroup getDefaultLabelGroup() {
        return this.defaultLabelGroup;
    }
}

