/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.grouping.functions;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.gradoop.common.model.api.entities.Attributed;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.api.entities.VertexFactory;
import org.gradoop.flink.model.impl.operators.grouping.functions.BuildBase;
import org.gradoop.flink.model.impl.operators.grouping.tuples.VertexGroupItem;

@FunctionAnnotation.ForwardedFields(value={"f1->id;f2->label"})
@FunctionAnnotation.ReadFields(value={"f1;f2;f3;f4;f6"})
public class BuildSuperVertex<V extends Vertex>
extends BuildBase
implements MapFunction<VertexGroupItem, V>,
ResultTypeQueryable<V> {
    private final VertexFactory<V> vertexFactory;

    public BuildSuperVertex(boolean useLabel, VertexFactory<V> epgmVertexFactory) {
        super(useLabel);
        this.vertexFactory = epgmVertexFactory;
    }

    public V map(VertexGroupItem groupItem) throws Exception {
        Vertex supVertex = this.vertexFactory.initVertex(groupItem.getSuperVertexId());
        supVertex.setLabel(groupItem.getGroupLabel());
        this.setGroupProperties((Attributed)supVertex, groupItem.getGroupingValues(), groupItem.getLabelGroup());
        this.setAggregateProperties((Attributed)supVertex, groupItem.getAggregateValues(), groupItem.getLabelGroup().getAggregateFunctions());
        return (V)supVertex;
    }

    public TypeInformation<V> getProducedType() {
        return TypeExtractor.createTypeInfo((Class)this.vertexFactory.getType());
    }
}

