/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.grouping.functions;

import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.impl.operators.grouping.functions.BuildGroupItemBase;
import org.gradoop.flink.model.impl.operators.grouping.tuples.LabelGroup;
import org.gradoop.flink.model.impl.operators.grouping.tuples.VertexGroupItem;

@FunctionAnnotation.ForwardedFields(value={"id->f0"})
@FunctionAnnotation.ReadFields(value={"label;properties"})
public class BuildVertexGroupItem<V extends Vertex>
extends BuildGroupItemBase
implements FlatMapFunction<V, VertexGroupItem> {
    private final VertexGroupItem reuseVertexGroupItem = new VertexGroupItem();

    public BuildVertexGroupItem(boolean useLabel, List<LabelGroup> vertexLabelGroups) {
        super(useLabel, vertexLabelGroups);
        this.reuseVertexGroupItem.setSuperVertexId(GradoopId.NULL_VALUE);
        this.reuseVertexGroupItem.setSuperVertex(false);
    }

    public void flatMap(V vertex, Collector<VertexGroupItem> collector) throws Exception {
        boolean usedVertexLabelGroup = false;
        this.reuseVertexGroupItem.setVertexId(vertex.getId());
        for (LabelGroup vertexLabelGroup : this.getLabelGroups()) {
            if (!vertexLabelGroup.getGroupingLabel().equals(vertex.getLabel())) continue;
            usedVertexLabelGroup = true;
            this.setGroupItem(this.reuseVertexGroupItem, (Element)vertex, vertexLabelGroup);
            collector.collect((Object)this.reuseVertexGroupItem);
        }
        if (!usedVertexLabelGroup) {
            this.setGroupItem(this.reuseVertexGroupItem, (Element)vertex, this.getDefaultLabelGroup());
            collector.collect((Object)this.reuseVertexGroupItem);
        }
    }
}

