/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.grouping.functions;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.configuration.Configuration;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.impl.operators.grouping.tuples.VertexGroupItem;
import org.gradoop.flink.model.impl.operators.grouping.tuples.VertexWithSuperVertex;
import org.gradoop.flink.model.impl.tuples.IdWithIdSet;

@FunctionAnnotation.ForwardedFields(value={"f0"})
public class BuildVertexWithSuperVertexBC
extends RichMapFunction<VertexGroupItem, VertexWithSuperVertex> {
    public static final String BC_MAPPING = "mapping";
    private final VertexWithSuperVertex reuseTuple = new VertexWithSuperVertex();
    private List<IdWithIdSet> mapping;
    private Map<GradoopId, GradoopId> cache = Maps.newConcurrentMap();

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.mapping = this.getRuntimeContext().getBroadcastVariable(BC_MAPPING);
    }

    public VertexWithSuperVertex map(VertexGroupItem item) throws Exception {
        this.reuseTuple.setVertexId(item.getVertexId());
        this.reuseTuple.setSuperVertexId(this.getFinalGroupRepresentative(item.getSuperVertexId()));
        return this.reuseTuple;
    }

    private GradoopId getFinalGroupRepresentative(GradoopId current) {
        GradoopId result = null;
        if (this.cache.containsKey(current)) {
            result = this.cache.get(current);
        } else {
            for (IdWithIdSet group : this.mapping) {
                if (!group.getIdSet().contains((Object)current)) continue;
                result = (GradoopId)group.f0;
                this.cache.put(current, result);
            }
        }
        return result;
    }
}

