/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.grouping.functions;

import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.api.entities.Attributed;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.EdgeFactory;
import org.gradoop.flink.model.impl.operators.grouping.functions.BuildSuperEdge;
import org.gradoop.flink.model.impl.operators.grouping.tuples.EdgeGroupItem;

@FunctionAnnotation.ForwardedFields(value={"f0->sourceId;f1->targetId;f2->label"})
@FunctionAnnotation.ReadFields(value={"f3;f5"})
public class ReduceEdgeGroupItems<E extends Edge>
extends BuildSuperEdge
implements GroupReduceFunction<EdgeGroupItem, E>,
ResultTypeQueryable<E> {
    private final EdgeFactory<E> edgeFactory;

    public ReduceEdgeGroupItems(boolean useLabel, EdgeFactory<E> edgeFactory) {
        super(useLabel);
        this.edgeFactory = edgeFactory;
    }

    public void reduce(Iterable<EdgeGroupItem> edgeGroupItems, Collector<E> collector) throws Exception {
        EdgeGroupItem edgeGroupItem = this.reduceInternal(edgeGroupItems);
        Edge superEdge = this.edgeFactory.createEdge(edgeGroupItem.getGroupLabel(), edgeGroupItem.getSourceId(), edgeGroupItem.getTargetId());
        this.setGroupProperties((Attributed)superEdge, edgeGroupItem.getGroupingValues(), edgeGroupItem.getLabelGroup());
        this.setAggregateProperties((Attributed)superEdge, edgeGroupItem.getLabelGroup().getAggregateValueList(), edgeGroupItem.getLabelGroup().getAggregateFunctions());
        edgeGroupItem.getLabelGroup().resetAggregateValues();
        collector.collect((Object)superEdge);
    }

    public TypeInformation<E> getProducedType() {
        return TypeExtractor.createTypeInfo((Class)this.edgeFactory.getType());
    }
}

