/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.grouping.functions;

import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.properties.PropertyValueList;
import org.gradoop.flink.model.impl.operators.grouping.functions.ReduceVertexGroupItemBase;
import org.gradoop.flink.model.impl.operators.grouping.tuples.VertexGroupItem;

@FunctionAnnotation.ForwardedFields(value={"f0;f2;f3;f4;f6"})
public class ReduceVertexGroupItems
extends ReduceVertexGroupItemBase
implements GroupReduceFunction<VertexGroupItem, VertexGroupItem> {
    public ReduceVertexGroupItems(boolean useLabel) {
        super(useLabel);
    }

    public void reduce(Iterable<VertexGroupItem> vertexGroupItems, Collector<VertexGroupItem> collector) throws Exception {
        GradoopId superVertexId = null;
        String groupLabel = null;
        PropertyValueList groupPropertyValues = null;
        VertexGroupItem reuseTuple = this.getReuseVertexGroupItem();
        boolean isFirst = true;
        for (VertexGroupItem groupItem : vertexGroupItems) {
            if (isFirst) {
                superVertexId = GradoopId.get();
                groupLabel = groupItem.getGroupLabel();
                groupPropertyValues = groupItem.getGroupingValues();
                reuseTuple.setGroupLabel(groupLabel);
                reuseTuple.setGroupingValues(groupPropertyValues);
                reuseTuple.setSuperVertexId(superVertexId);
                reuseTuple.setAggregateValues(groupItem.getAggregateValues());
                reuseTuple.setSuperVertex(groupItem.isSuperVertex());
                reuseTuple.setLabelGroup(groupItem.getLabelGroup());
                isFirst = false;
            }
            reuseTuple.setVertexId(groupItem.getVertexId());
            collector.collect((Object)reuseTuple);
            reuseTuple.getLabelGroup().aggregate(groupItem.getAggregateValues());
        }
        VertexGroupItem superVertex = this.createSuperVertexTuple(superVertexId, groupLabel, groupPropertyValues, reuseTuple.getLabelGroup().getAggregateValueList());
        superVertex.getLabelGroup().resetAggregateValues();
        collector.collect((Object)superVertex);
    }
}

