/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.grouping.functions;

import java.util.HashSet;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.id.GradoopIdSet;
import org.gradoop.common.model.impl.properties.PropertyValueList;
import org.gradoop.flink.model.impl.operators.grouping.functions.ReduceVertexGroupItemBase;
import org.gradoop.flink.model.impl.operators.grouping.tuples.LabelGroup;
import org.gradoop.flink.model.impl.operators.grouping.tuples.VertexGroupItem;
import org.gradoop.flink.model.impl.tuples.IdWithIdSet;

@FunctionAnnotation.ForwardedFields(value={"f0->f0.f0;f2->f0.f2;f3->f0.f3;f6->f0.f6"})
@FunctionAnnotation.ReadFields(value={"f4"})
public class TransposeVertexGroupItems
extends ReduceVertexGroupItemBase
implements GroupReduceFunction<VertexGroupItem, Tuple2<VertexGroupItem, IdWithIdSet>> {
    private final Tuple2<VertexGroupItem, IdWithIdSet> reuseOuterTuple = new Tuple2();
    private final IdWithIdSet reuseInnerTuple = new IdWithIdSet();

    public TransposeVertexGroupItems(boolean useLabel) {
        super(useLabel);
    }

    public void reduce(Iterable<VertexGroupItem> vertexGroupItems, Collector<Tuple2<VertexGroupItem, IdWithIdSet>> out) throws Exception {
        GradoopId superVertexId = null;
        String groupLabel = null;
        PropertyValueList groupPropertyValues = null;
        LabelGroup vertexLabelGroup = null;
        boolean isFirst = true;
        HashSet<GradoopId> superVertexIds = new HashSet<GradoopId>();
        for (VertexGroupItem groupItem : vertexGroupItems) {
            if (isFirst) {
                superVertexId = GradoopId.get();
                groupLabel = groupItem.getGroupLabel();
                groupPropertyValues = groupItem.getGroupingValues();
                vertexLabelGroup = groupItem.getLabelGroup();
                isFirst = false;
            }
            superVertexIds.add(groupItem.getSuperVertexId());
            vertexLabelGroup.aggregate(groupItem.getAggregateValues());
        }
        this.reuseInnerTuple.setId(superVertexId);
        this.reuseInnerTuple.setIdSet(GradoopIdSet.fromExisting(superVertexIds));
        this.reuseOuterTuple.f0 = this.createSuperVertexTuple(superVertexId, groupLabel, groupPropertyValues, vertexLabelGroup.getAggregateValueList());
        ((VertexGroupItem)this.reuseOuterTuple.f0).setSuperVertexId(superVertexId);
        ((VertexGroupItem)this.reuseOuterTuple.f0).setLabelGroup(vertexLabelGroup);
        this.reuseOuterTuple.f1 = this.reuseInnerTuple;
        ((VertexGroupItem)this.reuseOuterTuple.f0).getLabelGroup().resetAggregateValues();
        out.collect(this.reuseOuterTuple);
    }
}

