/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.grouping.tuples;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple5;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.common.model.impl.properties.PropertyValueList;
import org.gradoop.flink.model.api.functions.AggregateFunction;
import org.gradoop.flink.model.impl.operators.aggregation.functions.AggregateUtil;

public class LabelGroup
extends Tuple5<String, String, List<String>, List<AggregateFunction>, List<PropertyValue>> {
    public LabelGroup() {
        this(null, null);
    }

    public LabelGroup(String groupingLabel, String groupLabel) {
        this(groupingLabel, groupLabel, new ArrayList<String>(), new ArrayList<AggregateFunction>());
    }

    public LabelGroup(String groupingLabel, String groupLabel, List<String> propertyKeys, List<AggregateFunction> aggregators) {
        super((Object)groupingLabel, (Object)groupLabel, propertyKeys, aggregators, new ArrayList());
    }

    public String getGroupingLabel() {
        return (String)this.f0;
    }

    public void setGroupingLabel(String label) {
        this.f0 = label;
    }

    public String getGroupLabel() {
        return (String)this.f1;
    }

    public void setGroupLabel(String label) {
        this.f1 = label;
    }

    public List<String> getPropertyKeys() {
        return (List)this.f2;
    }

    public void setPropertyKeys(List<String> propertyKeys) {
        this.f2 = propertyKeys;
    }

    public void addPropertyKey(String propertyKey) {
        ((List)this.f2).add(propertyKey);
    }

    public List<AggregateFunction> getAggregateFunctions() {
        return (List)this.f3;
    }

    public void setAggregateFunctions(List<AggregateFunction> aggregateFunctions) {
        this.f3 = aggregateFunctions;
    }

    public void addAggregateFunction(AggregateFunction aggregateFunction) {
        ((List)this.f3).add(aggregateFunction);
    }

    public List<PropertyValue> getAggregateValues() {
        if (((List)this.f4).size() < ((List)this.f3).size()) {
            return ((List)this.f3).stream().map(AggregateUtil::getDefaultAggregate).collect(Collectors.toList());
        }
        return (List)this.f4;
    }

    public void setAggregateValues(List<PropertyValue> aggregateValues) {
        this.f4 = aggregateValues;
    }

    public void setAggregateValues(PropertyValueList aggregateValues) {
        ArrayList<PropertyValue> aggregate = new ArrayList<PropertyValue>();
        aggregateValues.iterator().forEachRemaining(aggregate::add);
        this.setAggregateValues(aggregate);
    }

    public void resetAggregateValues() {
        ((List)this.f4).clear();
    }

    public PropertyValueList getAggregateValueList() throws IOException {
        return PropertyValueList.fromPropertyValues(this.getAggregateValues());
    }

    public void aggregate(PropertyValueList values) {
        if (((List)this.f4).isEmpty()) {
            this.setAggregateValues(values);
            return;
        }
        Iterator valueIt = values.iterator();
        ListIterator<PropertyValue> aggregateIt = ((List)this.f4).listIterator();
        for (AggregateFunction valueAggregator : this.getAggregateFunctions()) {
            PropertyValue value = (PropertyValue)valueIt.next();
            if (PropertyValue.NULL_VALUE.equals((Object)value)) continue;
            PropertyValue aggregate = (PropertyValue)aggregateIt.next();
            if (!PropertyValue.NULL_VALUE.equals((Object)aggregate)) {
                aggregateIt.set(valueAggregator.aggregate(aggregate, value));
                continue;
            }
            aggregateIt.set(value);
        }
    }

    public PropertyValueList getIncrementValues(Element element) throws IOException {
        if (((List)this.f3).isEmpty()) {
            return PropertyValueList.createEmptyList();
        }
        List propertyValues = this.getAggregateFunctions().stream().map(f -> LabelGroup.getIncrement(f, element)).collect(Collectors.toList());
        return PropertyValueList.fromPropertyValues(propertyValues);
    }

    private static PropertyValue getIncrement(AggregateFunction aggregateFunction, Element element) {
        PropertyValue increment = null;
        if (element instanceof Vertex && aggregateFunction.isVertexAggregation() || element instanceof Edge && aggregateFunction.isEdgeAggregation()) {
            increment = aggregateFunction.getIncrement(element);
        }
        return increment == null ? AggregateUtil.getDefaultAggregate(aggregateFunction) : increment;
    }
}

