/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.keyedgrouping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.functions.AggregateFunction;
import org.gradoop.flink.model.api.functions.KeyFunction;
import org.gradoop.flink.model.impl.operators.grouping.tuples.LabelGroup;
import org.gradoop.flink.model.impl.operators.keyedgrouping.GroupingKeys;
import org.gradoop.flink.model.impl.operators.keyedgrouping.KeyedGrouping;
import org.gradoop.flink.model.impl.operators.keyedgrouping.labelspecific.LabelSpecificAggregatorWrapper;
import org.gradoop.flink.model.impl.operators.keyedgrouping.labelspecific.LabelSpecificKeyFunction;
import org.gradoop.flink.model.impl.operators.keyedgrouping.labelspecific.UnlabeledGroupAggregatorWrapper;

public final class KeyedGroupingUtils {
    private KeyedGroupingUtils() {
    }

    public static List<AggregateFunction> asAggregateFunctions(List<LabelGroup> labelGroups) {
        List<AggregateFunction> functions;
        LabelGroup defaultGroup = KeyedGroupingUtils.getDefaultGroupOrNull(labelGroups);
        if (defaultGroup == null) {
            functions = new ArrayList<AggregateFunction>();
            AtomicInteger id = new AtomicInteger(0);
            Set allLabels = labelGroups.stream().map(LabelGroup::getGroupingLabel).collect(Collectors.toSet());
            for (LabelGroup labelGroup : labelGroups) {
                String currentLabel = labelGroup.getGroupingLabel();
                if (currentLabel.equals(":defaultVertexLabelGroup") || currentLabel.equals(":defaultEdgeLabelGroup")) {
                    labelGroup.getAggregateFunctions().forEach(lga -> functions.add(new UnlabeledGroupAggregatorWrapper(allLabels, (AggregateFunction)lga, (short)id.getAndIncrement())));
                    continue;
                }
                labelGroup.getAggregateFunctions().forEach(lga -> functions.add(new LabelSpecificAggregatorWrapper(currentLabel, (AggregateFunction)lga, (short)id.getAndIncrement())));
            }
        } else {
            functions = defaultGroup.getAggregateFunctions();
        }
        return functions;
    }

    public static <T extends Element> List<KeyFunction<T, ?>> asKeyFunctions(boolean useLabels, List<LabelGroup> labelGroups) {
        LabelGroup defaultGroup = KeyedGroupingUtils.getDefaultGroupOrNull(labelGroups);
        ArrayList newKeys = new ArrayList();
        if (defaultGroup == null) {
            newKeys.add(KeyedGroupingUtils.asKeyFunction(useLabels, labelGroups));
        } else {
            defaultGroup.getPropertyKeys().forEach(k -> newKeys.add(GroupingKeys.property(k)));
            if (useLabels) {
                newKeys.add(GroupingKeys.label());
            }
        }
        return newKeys;
    }

    public static <T extends Element> LabelSpecificKeyFunction<T> asKeyFunction(boolean useLabels, List<LabelGroup> labelGroups) {
        HashMap keyFunctions = new HashMap();
        for (LabelGroup labelGroup : labelGroups) {
            String groupingLabel = labelGroup.getGroupingLabel();
            if (keyFunctions.containsKey(groupingLabel)) {
                throw new UnsupportedOperationException("Duplicate grouping label: " + groupingLabel);
            }
            ArrayList keysForLabel = new ArrayList();
            if ((groupingLabel.equals(":defaultVertexLabelGroup") || groupingLabel.equals(":defaultEdgeLabelGroup")) && useLabels) {
                keysForLabel.add(GroupingKeys.label());
            }
            labelGroup.getPropertyKeys().forEach(k -> keysForLabel.add(GroupingKeys.property(k)));
            keyFunctions.put(groupingLabel, keysForLabel);
        }
        Map<String, String> labelUpdateMap = labelGroups.stream().collect(Collectors.toMap(LabelGroup::getGroupingLabel, LabelGroup::getGroupLabel));
        return new LabelSpecificKeyFunction(keyFunctions, labelUpdateMap);
    }

    public static <G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>> KeyedGrouping<G, V, E, LG, GC> createInstance(boolean useVertexLabels, boolean useEdgeLabels, List<LabelGroup> vertexLabelGroups, List<LabelGroup> edgeLabelGroups, List<AggregateFunction> globalVertexAggregators, List<AggregateFunction> globalEdgeAggregators) {
        List<AggregateFunction> vertexAggregators = KeyedGroupingUtils.asAggregateFunctions(vertexLabelGroups);
        vertexAggregators.addAll(globalVertexAggregators);
        List<AggregateFunction> edgeAggregators = KeyedGroupingUtils.asAggregateFunctions(edgeLabelGroups);
        edgeAggregators.addAll(globalEdgeAggregators);
        return new KeyedGrouping(KeyedGroupingUtils.asKeyFunctions(useVertexLabels, vertexLabelGroups), vertexAggregators, KeyedGroupingUtils.asKeyFunctions(useEdgeLabels, edgeLabelGroups), edgeAggregators);
    }

    private static LabelGroup getDefaultGroupOrNull(List<LabelGroup> labelGroups) {
        if (labelGroups.size() != 1) {
            return null;
        }
        LabelGroup labelGroup = labelGroups.get(0);
        if (!labelGroup.getGroupingLabel().equals(":defaultEdgeLabelGroup") && !labelGroup.getGroupingLabel().equals(":defaultVertexLabelGroup")) {
            return null;
        }
        return labelGroup;
    }
}

