/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.keyedgrouping.functions;

import java.util.List;
import java.util.Objects;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.EdgeFactory;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.api.functions.AggregateFunction;
import org.gradoop.flink.model.api.functions.KeyFunction;
import org.gradoop.flink.model.impl.operators.keyedgrouping.functions.BuildSuperElementFromTuple;

public class BuildSuperEdgeFromTuple<T extends Tuple, E extends Edge>
extends BuildSuperElementFromTuple<T, E> {
    private final Class<E> edgeType;
    private final E reuse;

    public BuildSuperEdgeFromTuple(List<KeyFunction<E, ?>> groupingKeys, List<AggregateFunction> aggregateFunctions, EdgeFactory<E> edgeFactory) {
        super(2, groupingKeys, aggregateFunctions);
        this.reuse = Objects.requireNonNull(edgeFactory).createEdge(GradoopId.NULL_VALUE, GradoopId.NULL_VALUE);
        this.edgeType = edgeFactory.getType();
    }

    public E map(T tuple) throws Exception {
        Edge edge = (Edge)this.setAggregatePropertiesAndKeys(this.reuse, tuple);
        edge.setId(GradoopId.get());
        edge.setSourceId((GradoopId)tuple.getField(0));
        edge.setTargetId((GradoopId)tuple.getField(1));
        return (E)edge;
    }

    public TypeInformation<E> getProducedType() {
        return TypeInformation.of(this.edgeType);
    }
}

