/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.keyedgrouping.functions;

import java.util.List;
import java.util.Objects;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.impl.properties.Properties;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.functions.AggregateFunction;
import org.gradoop.flink.model.api.functions.KeyFunction;
import org.gradoop.flink.model.impl.operators.aggregation.functions.AggregateUtil;

abstract class BuildSuperElementFromTuple<T extends Tuple, E extends Element>
implements MapFunction<T, E>,
ResultTypeQueryable<E> {
    private final int tupleDataOffset;
    private final List<KeyFunction<E, ?>> keyFunctions;
    private final List<AggregateFunction> aggregateFunctions;

    BuildSuperElementFromTuple(int tupleDataOffset, List<KeyFunction<E, ?>> groupingKeys, List<AggregateFunction> aggregateFunctions) {
        this.tupleDataOffset = tupleDataOffset;
        this.keyFunctions = Objects.requireNonNull(groupingKeys);
        this.aggregateFunctions = Objects.requireNonNull(aggregateFunctions);
    }

    E setAggregatePropertiesAndKeys(E element, T tupleData) {
        int i;
        element.setLabel("");
        element.setProperties(Properties.create());
        for (i = 0; i < this.keyFunctions.size(); ++i) {
            Object groupingKey = tupleData.getField(this.tupleDataOffset + i);
            this.keyFunctions.get(i).addKeyToElement(element, groupingKey);
        }
        for (i = 0; i < this.aggregateFunctions.size(); ++i) {
            AggregateFunction function = this.aggregateFunctions.get(i);
            PropertyValue postAggregateValue = function.postAggregate((PropertyValue)tupleData.getField(this.tupleDataOffset + this.keyFunctions.size() + i));
            if (postAggregateValue == null) continue;
            element.setProperty(function.getAggregatePropertyKey(), postAggregateValue.isNull() ? AggregateUtil.getDefaultAggregate(function) : postAggregateValue);
        }
        return element;
    }
}

