/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.keyedgrouping.functions;

import java.util.List;
import java.util.Objects;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.functions.AggregateFunction;
import org.gradoop.flink.model.api.functions.KeyFunction;

public class BuildTuplesFromElements<E extends Element>
implements MapFunction<E, Tuple>,
ResultTypeQueryable<Tuple> {
    private final List<KeyFunction<E, ?>> keys;
    private final List<AggregateFunction> aggregateFunctions;
    private final int tupleDataOffset;
    private final TypeInformation<?>[] elementTypes;
    private final Tuple reuseTuple;

    public BuildTuplesFromElements(int tupleDataOffset, List<KeyFunction<E, ?>> keys, List<AggregateFunction> aggregateFunctions) {
        int i;
        this.tupleDataOffset = tupleDataOffset;
        if (tupleDataOffset < 0) {
            throw new IllegalArgumentException("The number of reserved tuple fields must not be negative.");
        }
        this.keys = Objects.requireNonNull(keys);
        this.aggregateFunctions = Objects.requireNonNull(aggregateFunctions);
        int tupleSize = tupleDataOffset + keys.size() + aggregateFunctions.size();
        if (tupleSize > 25) {
            throw new UnsupportedOperationException("Number of elements is too high for tuple: " + tupleSize + " (max.: " + 25 + ")");
        }
        this.elementTypes = new TypeInformation[tupleSize];
        for (i = 0; i < tupleDataOffset; ++i) {
            this.elementTypes[i] = TypeInformation.of(GradoopId.class);
        }
        for (i = 0; i < keys.size(); ++i) {
            this.elementTypes[i + tupleDataOffset] = keys.get(i).getType();
        }
        for (i = 0; i < aggregateFunctions.size(); ++i) {
            this.elementTypes[i + keys.size() + tupleDataOffset] = TypeInformation.of(PropertyValue.class);
        }
        this.reuseTuple = Tuple.newInstance((int)tupleSize);
        for (i = 0; i < tupleDataOffset; ++i) {
            this.reuseTuple.setField((Object)GradoopId.NULL_VALUE, i);
        }
    }

    public TypeInformation<Tuple> getProducedType() {
        return new TupleTypeInfo(this.elementTypes);
    }

    public Tuple map(E element) throws Exception {
        int field = this.tupleDataOffset;
        for (KeyFunction<E, ?> key : this.keys) {
            this.reuseTuple.setField(key.getKey(element), field);
            ++field;
        }
        for (AggregateFunction aggregateFunction : this.aggregateFunctions) {
            PropertyValue increment = aggregateFunction.getIncrement((Element)element);
            this.reuseTuple.setField((Object)(increment == null ? PropertyValue.NULL_VALUE : increment), field);
            ++field;
        }
        return this.reuseTuple;
    }
}

