/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.keyedgrouping.functions;

import java.util.List;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.java.tuple.Tuple;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.functions.AggregateFunction;

abstract class ReduceElementTuples<T extends Tuple>
implements GroupReduceFunction<T, T> {
    private final int tupleDataOffset;
    private final List<AggregateFunction> aggregateFunctions;

    ReduceElementTuples(int tupleDataOffset, List<AggregateFunction> aggregateFunctions) {
        this.tupleDataOffset = tupleDataOffset;
        this.aggregateFunctions = aggregateFunctions;
    }

    void callAggregateFunctions(T superTuple, T inputTuple) {
        for (int i = 0; i < this.aggregateFunctions.size(); ++i) {
            PropertyValue aggregate = (PropertyValue)superTuple.getField(i + this.tupleDataOffset);
            PropertyValue increment = (PropertyValue)inputTuple.getField(i + this.tupleDataOffset);
            inputTuple.setField((Object)PropertyValue.NULL_VALUE, i + this.tupleDataOffset);
            if (increment.equals((Object)PropertyValue.NULL_VALUE)) continue;
            if (aggregate.equals((Object)PropertyValue.NULL_VALUE)) {
                superTuple.setField((Object)increment, i + this.tupleDataOffset);
                continue;
            }
            superTuple.setField((Object)this.aggregateFunctions.get(i).aggregate(aggregate, increment), i + this.tupleDataOffset);
        }
    }
}

