/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.keyedgrouping.functions;

import java.util.List;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.api.functions.AggregateFunction;
import org.gradoop.flink.model.impl.operators.keyedgrouping.functions.ReduceElementTuples;

public class ReduceVertexTuples<T extends Tuple>
extends ReduceElementTuples<T> {
    public ReduceVertexTuples(int tupleDataOffset, List<AggregateFunction> aggregateFunctions) {
        super(tupleDataOffset, aggregateFunctions);
    }

    public void reduce(Iterable<T> input, Collector<T> out) throws Exception {
        Tuple superVertexTuple = null;
        GradoopId superVertexId = GradoopId.get();
        for (Tuple inputTuple : input) {
            if (superVertexTuple == null) {
                superVertexTuple = inputTuple.copy();
            } else {
                this.callAggregateFunctions(superVertexTuple, inputTuple);
            }
            inputTuple.setField((Object)superVertexId, 1);
            out.collect((Object)inputTuple);
        }
        if (superVertexTuple == null) {
            throw new IllegalStateException("Super-vertex was not initialized. Do not call this function on empty groups.");
        }
        superVertexTuple.setField((Object)superVertexId, 0);
        superVertexTuple.setField((Object)superVertexId, 1);
        out.collect((Object)superVertexTuple);
    }
}

