/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.keyedgrouping.keys;

import java.util.List;
import java.util.Objects;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.gradoop.flink.model.api.functions.KeyFunction;

public class CompositeKeyFunction<T>
implements KeyFunction<T, Tuple> {
    private final List<? extends KeyFunction<T, ?>> componentFunctions;
    private final Tuple reuseTuple;

    public CompositeKeyFunction(List<? extends KeyFunction<T, ?>> keyFunctions) {
        this.componentFunctions = Objects.requireNonNull(keyFunctions);
        if (keyFunctions.size() > 25) {
            throw new IllegalArgumentException("Too many keys. Maximum tuple arity exceeded: " + keyFunctions.size() + " (max.: " + 25 + ")");
        }
        this.reuseTuple = Tuple.newInstance((int)this.componentFunctions.size());
    }

    @Override
    public Tuple getKey(T element) {
        for (int index = 0; index < this.componentFunctions.size(); ++index) {
            this.reuseTuple.setField(this.componentFunctions.get(index).getKey(element), index);
        }
        return this.reuseTuple;
    }

    @Override
    public void addKeyToElement(T element, Object key) {
        if (!(key instanceof Tuple)) {
            throw new IllegalArgumentException("Invalid type for key: " + key.getClass().getSimpleName());
        }
        for (int nr = 0; nr < this.componentFunctions.size(); ++nr) {
            this.componentFunctions.get(nr).addKeyToElement(element, ((Tuple)key).getField(nr));
        }
    }

    @Override
    public TypeInformation<Tuple> getType() {
        TypeInformation[] types = new TypeInformation[this.componentFunctions.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.componentFunctions.get(i).getType();
        }
        return new TupleTypeInfo(types);
    }
}

