/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.keyedgrouping.keys;

import java.util.Objects;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.gradoop.common.model.api.entities.Attributed;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.functions.KeyFunctionWithDefaultValue;

public class PropertyKeyFunction<T extends Attributed>
implements KeyFunctionWithDefaultValue<T, byte[]> {
    private final String propertyKey;

    public PropertyKeyFunction(String propertyKey) {
        this.propertyKey = Objects.requireNonNull(propertyKey);
    }

    @Override
    public byte[] getKey(T element) {
        PropertyValue value = element.getPropertyValue(this.propertyKey);
        return value == null ? PropertyValue.NULL_VALUE.getRawBytes() : value.getRawBytes();
    }

    @Override
    public void addKeyToElement(T element, Object key) {
        if (!(key instanceof byte[])) {
            throw new IllegalArgumentException("Invalid type for key: " + key.getClass().getSimpleName());
        }
        element.setProperty(this.propertyKey, PropertyValue.fromRawBytes((byte[])((byte[])key)));
    }

    @Override
    public TypeInformation<byte[]> getType() {
        return TypeInformation.of(byte[].class);
    }

    @Override
    public byte[] getDefaultKey() {
        return PropertyValue.NULL_VALUE.getRawBytes();
    }
}

