/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.keyedgrouping.labelspecific;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.functions.AggregateDefaultValue;
import org.gradoop.flink.model.api.functions.AggregateFunction;

abstract class AggregatorWrapperWithValue
implements AggregateFunction,
AggregateDefaultValue {
    protected final AggregateFunction wrappedFunction;
    private final PropertyValue identifyingValue;

    AggregatorWrapperWithValue(AggregateFunction wrappedFunction, PropertyValue identifyingValue) {
        this.wrappedFunction = Objects.requireNonNull(wrappedFunction);
        this.identifyingValue = Objects.requireNonNull(identifyingValue);
    }

    protected PropertyValue unwrap(PropertyValue wrappedValue) {
        if (wrappedValue.isNull()) {
            return wrappedValue;
        }
        return (PropertyValue)wrappedValue.getList().get(1);
    }

    protected PropertyValue wrap(PropertyValue rawValue) {
        return PropertyValue.create(Arrays.asList(this.identifyingValue, rawValue));
    }

    protected boolean isAggregated(PropertyValue value) {
        if (!value.isList()) {
            return false;
        }
        List values = value.getList();
        if (values.size() != 2) {
            return false;
        }
        return this.identifyingValue.equals(values.get(0));
    }

    @Override
    public PropertyValue aggregate(PropertyValue aggregate, PropertyValue increment) {
        if (this.isAggregated(increment)) {
            return this.wrap(this.wrappedFunction.aggregate(this.unwrap(aggregate), this.unwrap(increment)));
        }
        return aggregate;
    }

    @Override
    public String getAggregatePropertyKey() {
        return this.wrappedFunction.getAggregatePropertyKey();
    }

    @Override
    public PropertyValue postAggregate(PropertyValue result) {
        if (this.isAggregated(result)) {
            return this.wrappedFunction.postAggregate(this.unwrap(result));
        }
        return null;
    }

    @Override
    public PropertyValue getDefaultValue() {
        return this.wrappedFunction instanceof AggregateDefaultValue ? ((AggregateDefaultValue)((Object)this.wrappedFunction)).getDefaultValue() : PropertyValue.NULL_VALUE;
    }
}

