/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.keyedgrouping.labelspecific;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.flink.model.api.functions.KeyFunction;
import org.gradoop.flink.model.api.functions.KeyFunctionWithDefaultValue;
import org.gradoop.flink.model.impl.operators.keyedgrouping.keys.CompositeKeyFunctionWithDefaultValues;

public class LabelSpecificKeyFunction<T extends Element>
implements KeyFunction<T, Tuple> {
    public static final String DEFAULT_GROUP_LABEL = ":defaultVertexLabelGroup";
    private final Map<String, Integer> labelToIndex;
    private final List<KeyFunctionWithDefaultValue<T, ?>> keyFunctions;
    private final String[] targetLabels;
    private final Tuple reuseTuple;

    public LabelSpecificKeyFunction(Map<String, List<KeyFunctionWithDefaultValue<T, ?>>> labelsWithKeys, Map<String, String> labelToSuperLabel) {
        String defaultGroupLabel;
        boolean hasDefaultVertexGroup = labelsWithKeys.containsKey(DEFAULT_GROUP_LABEL);
        boolean hasDefaultEdgeGroup = labelsWithKeys.containsKey(":defaultEdgeLabelGroup");
        if (hasDefaultEdgeGroup && hasDefaultVertexGroup) {
            throw new IllegalArgumentException("The map contains both default label groups. Only one is expected.");
        }
        if (hasDefaultVertexGroup) {
            defaultGroupLabel = DEFAULT_GROUP_LABEL;
        } else if (hasDefaultEdgeGroup) {
            defaultGroupLabel = ":defaultEdgeLabelGroup";
        } else {
            throw new IllegalArgumentException("The map contains no default label groups. One is expected.");
        }
        int totalLabels = Objects.requireNonNull(labelsWithKeys).size();
        if (totalLabels + 1 > 25) {
            throw new IllegalArgumentException("Too many labels. Tuple arity exceeded: " + (totalLabels + 1) + " (max.: " + 25 + ")");
        }
        int labelNr = 1;
        this.labelToIndex = new HashMap<String, Integer>();
        this.keyFunctions = new ArrayList<Object>(Collections.nCopies(totalLabels, null));
        this.targetLabels = new String[totalLabels];
        for (Map.Entry<String, List<KeyFunctionWithDefaultValue<T, ?>>> entry : labelsWithKeys.entrySet()) {
            String key = entry.getKey();
            List<KeyFunctionWithDefaultValue<T, ?>> keysForLabel = entry.getValue();
            if (key.equals(defaultGroupLabel)) {
                this.keyFunctions.set(0, keysForLabel.size() == 1 ? keysForLabel.get(0) : new CompositeKeyFunctionWithDefaultValues<T>(keysForLabel));
                continue;
            }
            this.labelToIndex.put(key, labelNr);
            this.targetLabels[labelNr] = key;
            this.keyFunctions.set(labelNr, keysForLabel.size() == 1 ? keysForLabel.get(0) : new CompositeKeyFunctionWithDefaultValues<T>(keysForLabel));
            ++labelNr;
        }
        if (labelToSuperLabel != null) {
            for (Map.Entry<String, Object> entry : labelToSuperLabel.entrySet()) {
                Integer index = this.labelToIndex.get(entry.getKey());
                if (index == null) continue;
                this.targetLabels[index.intValue()] = (String)entry.getValue();
            }
        }
        this.reuseTuple = Tuple.newInstance((int)(1 + totalLabels));
    }

    @Override
    public Tuple getKey(T element) {
        Integer index = this.labelToIndex.get(element.getLabel());
        for (int i = 0; i < this.keyFunctions.size(); ++i) {
            this.reuseTuple.setField(this.keyFunctions.get(i).getDefaultKey(), 1 + i);
        }
        if (index == null) {
            index = 0;
        }
        this.reuseTuple.setField(this.keyFunctions.get(index).getKey(element), 1 + index);
        this.reuseTuple.setField((Object)index, 0);
        return this.reuseTuple;
    }

    @Override
    public void addKeyToElement(T element, Object key) {
        if (!(key instanceof Tuple)) {
            throw new IllegalArgumentException("Invalid type for key: " + key.getClass().getSimpleName());
        }
        Integer index = (Integer)((Tuple)key).getField(0);
        this.keyFunctions.get(index).addKeyToElement(element, ((Tuple)key).getField(1 + index));
        if (index != 0) {
            element.setLabel(this.targetLabels[index]);
        }
    }

    @Override
    public TypeInformation<Tuple> getType() {
        TypeInformation[] types = new TypeInformation[1 + this.keyFunctions.size()];
        types[0] = BasicTypeInfo.INT_TYPE_INFO;
        for (int index = 0; index < this.keyFunctions.size(); ++index) {
            types[1 + index] = this.keyFunctions.get(index).getType();
        }
        return new TupleTypeInfo(types);
    }
}

