/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.operators.TwoInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.EdgeFactory;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.api.entities.VertexFactory;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.epgm.BaseGraphCollectionFactory;
import org.gradoop.flink.model.impl.functions.epgm.EdgeFromIds;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.MergedGraphIds;
import org.gradoop.flink.model.impl.functions.epgm.VertexFromId;
import org.gradoop.flink.model.impl.functions.utils.Cast;
import org.gradoop.flink.model.impl.functions.utils.IsInstance;
import org.gradoop.flink.model.impl.functions.utils.RightSide;
import org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.functions.EdgeTriple;
import org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.tuples.FatVertex;

public class PostProcessor {
    public static <G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>> GC extractGraphCollection(DataSet<Element> elements, BaseGraphCollectionFactory<G, V, E, LG, GC> factory, boolean mayOverlap) {
        Class graphHeadType = factory.getGraphHeadFactory().getType();
        Class vertexType = factory.getVertexFactory().getType();
        Class edgeType = factory.getEdgeFactory().getType();
        return factory.fromDataSets(PostProcessor.extractGraphHeads(elements, graphHeadType), PostProcessor.extractVertices(elements, vertexType, mayOverlap), PostProcessor.extractEdges(elements, edgeType, mayOverlap));
    }

    public static <G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>> GC extractGraphCollectionWithData(DataSet<Element> elements, LG inputGraph, boolean mayOverlap) {
        BaseGraphCollectionFactory factory = inputGraph.getCollectionFactory();
        GC collection = PostProcessor.extractGraphCollection(elements, factory, mayOverlap);
        TwoInputUdfOperator newVertices = inputGraph.getVertices().rightOuterJoin(collection.getVertices()).where(new Id()).equalTo(new Id()).with(new MergedGraphIds()).withForwardedFieldsFirst(new String[]{"id;label;properties;"});
        TwoInputUdfOperator newEdges = inputGraph.getEdges().rightOuterJoin(collection.getEdges()).where(new Id()).equalTo(new Id()).with(new MergedGraphIds()).withForwardedFieldsFirst(new String[]{"id;label;properties"});
        return factory.fromDataSets(collection.getGraphHeads(), (DataSet<V>)newVertices, (DataSet<E>)newEdges);
    }

    private static DataSet<Tuple1<GradoopId>> extractVertexIds(DataSet<FatVertex> result) {
        return result.project(new int[]{0});
    }

    private static DataSet<Tuple3<GradoopId, GradoopId, GradoopId>> extractEdgeIds(DataSet<FatVertex> result) {
        return result.flatMap((FlatMapFunction)new EdgeTriple());
    }

    private static <G extends GraphHead> DataSet<G> extractGraphHeads(DataSet<Element> elements, Class<G> graphHeadType) {
        return elements.filter(new IsInstance(graphHeadType)).map(new Cast(graphHeadType)).returns(TypeExtractor.createTypeInfo(graphHeadType));
    }

    public static <V extends Vertex> DataSet<V> extractVertices(DataSet<FatVertex> result, VertexFactory<V> vertexFactory) {
        return PostProcessor.extractVertexIds(result).map(new VertexFromId<V>(vertexFactory));
    }

    private static <V extends Vertex> DataSet<V> extractVertices(DataSet<Element> elements, Class<V> vertexType, boolean mayOverlap) {
        SingleInputUdfOperator result = elements.filter(new IsInstance(vertexType)).map(new Cast(vertexType)).returns(TypeExtractor.createTypeInfo(vertexType));
        return mayOverlap ? result.groupBy(new Id()).combineGroup(new MergedGraphIds()).groupBy(new Id()).reduceGroup(new MergedGraphIds()) : result;
    }

    public static <E extends Edge> DataSet<E> extractEdges(DataSet<FatVertex> result, EdgeFactory<E> edgeFactory) {
        return PostProcessor.extractEdgeIds(result).map(new EdgeFromIds<E>(edgeFactory));
    }

    private static <E extends Edge> DataSet<E> extractEdges(DataSet<Element> elements, Class<E> edgeType, boolean mayOverlap) {
        SingleInputUdfOperator result = elements.filter(new IsInstance(edgeType)).map(new Cast(edgeType)).returns(TypeExtractor.createTypeInfo(edgeType));
        return mayOverlap ? result.groupBy(new Id()).combineGroup(new MergedGraphIds()).groupBy(new Id()).reduceGroup(new MergedGraphIds()) : result;
    }

    public static <V extends Vertex> DataSet<V> extractVerticesWithData(DataSet<FatVertex> result, DataSet<V> inputVertices) {
        return PostProcessor.extractVertexIds(result).join(inputVertices).where(new int[]{0}).equalTo(new Id()).with(new RightSide());
    }

    public static <E extends Edge> DataSet<E> extractEdgesWithData(DataSet<FatVertex> result, DataSet<E> inputEdges) {
        return PostProcessor.extractEdgeIds(result).join(inputEdges).where(new int[]{0}).equalTo(new Id()).with(new RightSide());
    }
}

