/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common;

import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.java.DataSet;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.impl.operators.matching.common.functions.BuildIdWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.common.functions.BuildTripleWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.common.functions.MatchingEdges;
import org.gradoop.flink.model.impl.operators.matching.common.functions.MatchingPairs;
import org.gradoop.flink.model.impl.operators.matching.common.functions.MatchingTriples;
import org.gradoop.flink.model.impl.operators.matching.common.functions.MatchingVertices;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.IdWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.TripleWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.TripleWithSourceEdgeCandidates;

public class PreProcessor {
    public static <G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>> DataSet<IdWithCandidates<GradoopId>> filterVertices(LG graph, String query) {
        return graph.getVertices().filter(new MatchingVertices(query)).map(new BuildIdWithCandidates(query));
    }

    public static <G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>> DataSet<TripleWithCandidates<GradoopId>> filterEdges(LG graph, String query) {
        return graph.getEdges().filter(new MatchingEdges(query)).map(new BuildTripleWithCandidates(query));
    }

    private static <G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>> DataSet<TripleWithSourceEdgeCandidates<GradoopId>> filterPairs(LG graph, String query, DataSet<IdWithCandidates<GradoopId>> filteredVertices) {
        return filteredVertices.join(PreProcessor.filterEdges(graph, query)).where(new int[]{0}).equalTo(new int[]{1}).with((FlatJoinFunction)new MatchingPairs(query));
    }

    public static <G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>> DataSet<TripleWithCandidates<GradoopId>> filterTriplets(LG graph, String query) {
        return PreProcessor.filterTriplets(graph, query, PreProcessor.filterVertices(graph, query));
    }

    private static <G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>> DataSet<TripleWithCandidates<GradoopId>> filterTriplets(LG graph, String query, DataSet<IdWithCandidates<GradoopId>> filteredVertices) {
        return PreProcessor.filterPairs(graph, query, filteredVertices).join(filteredVertices).where(new int[]{3}).equalTo(new int[]{0}).with((FlatJoinFunction)new MatchingTriples(query));
    }
}

