/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common.debug;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.log4j.Logger;
import org.gradoop.common.model.impl.properties.PropertyValue;

@FunctionAnnotation.ForwardedFields(value={"*"})
public abstract class Printer<IN, K>
extends RichMapFunction<IN, IN> {
    public static final String VERTEX_MAPPING = "vertexMapping";
    public static final String EDGE_MAPPING = "edgeMapping";
    private static final Logger LOG = Logger.getLogger(Printer.class);
    protected Map<K, PropertyValue> vertexMap;
    protected Map<K, PropertyValue> edgeMap;
    protected final String prefix;
    protected final boolean isIterative;
    private final int iterationNumber;

    public Printer() {
        this(false, "");
    }

    public Printer(boolean isIterative, String prefix) {
        this.isIterative = isIterative;
        this.iterationNumber = 0;
        this.prefix = prefix;
    }

    public Printer(int iterationNumber, String prefix) {
        this.isIterative = false;
        this.iterationNumber = iterationNumber;
        this.prefix = prefix;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        List vertexMapping = this.getRuntimeContext().getBroadcastVariable(VERTEX_MAPPING);
        this.vertexMap = this.initMapping(vertexMapping);
        List edgeMapping = this.getRuntimeContext().getBroadcastVariable(EDGE_MAPPING);
        this.edgeMap = this.initMapping(edgeMapping);
    }

    public IN map(IN in) throws Exception {
        this.getLogger().debug((Object)String.format("%s%s", this.getHeader(), this.getDebugString(in)));
        return in;
    }

    protected abstract String getDebugString(IN var1);

    protected abstract Logger getLogger();

    private String getHeader() {
        return String.format("[%d][%s]: ", this.isIterative ? this.getIterationRuntimeContext().getSuperstepNumber() : this.iterationNumber, this.prefix != null && !this.prefix.isEmpty() ? this.prefix : " ");
    }

    private Map<K, PropertyValue> initMapping(List<Tuple2<K, PropertyValue>> tuples) {
        HashMap map = Maps.newHashMap();
        for (Tuple2<K, PropertyValue> tuple : tuples) {
            map.put(tuple.f0, tuple.f1);
        }
        return map;
    }

    protected List<PropertyValue> convertList(List<K> ids, boolean isVertex) {
        ArrayList result = Lists.newArrayListWithCapacity((int)ids.size());
        for (K gradoopId : ids) {
            result.add(isVertex ? this.vertexMap.get(gradoopId) : this.edgeMap.get(gradoopId));
        }
        return result;
    }

    private static <K> boolean isDebugEnabled(DataSet<Tuple2<K, PropertyValue>> vertexMapping, DataSet<Tuple2<K, PropertyValue>> edgeMapping) {
        return LOG.isDebugEnabled() && vertexMapping != null && edgeMapping != null;
    }

    public static <T, K> DataSet<T> log(DataSet<T> dataSet, Printer<T, K> printer, DataSet<Tuple2<K, PropertyValue>> vertexMapping, DataSet<Tuple2<K, PropertyValue>> edgeMapping) {
        if (Printer.isDebugEnabled(vertexMapping, edgeMapping)) {
            return ((MapOperator)dataSet.map(printer).withBroadcastSet(vertexMapping, VERTEX_MAPPING)).withBroadcastSet(edgeMapping, EDGE_MAPPING);
        }
        return dataSet;
    }
}

