/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common.functions;

import java.util.Collection;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.configuration.Configuration;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.impl.operators.matching.common.functions.AbstractBuilder;
import org.gradoop.flink.model.impl.operators.matching.common.matching.ElementMatcher;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.TripleWithCandidates;
import org.s1ck.gdl.model.Edge;

@FunctionAnnotation.ForwardedFields(value={"id->f0;sourceId->f1;targetId->f2"})
public class BuildTripleWithCandidates<E extends org.gradoop.common.model.api.entities.Edge>
extends AbstractBuilder<E, TripleWithCandidates<GradoopId>> {
    private static final long serialVersionUID = 42L;
    private transient Collection<Edge> queryEdges;
    private int edgeCount;
    private final TripleWithCandidates<GradoopId> reuseTuple = new TripleWithCandidates();

    public BuildTripleWithCandidates(String query) {
        super(query);
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.queryEdges = this.getQueryHandler().getEdges();
        this.edgeCount = this.queryEdges.size();
    }

    public TripleWithCandidates<GradoopId> map(E e) throws Exception {
        this.reuseTuple.setEdgeId(e.getId());
        this.reuseTuple.setSourceId(e.getSourceId());
        this.reuseTuple.setTargetId(e.getTargetId());
        this.reuseTuple.setCandidates(this.getCandidates(this.edgeCount, ElementMatcher.getMatches(e, this.queryEdges, "")));
        return this.reuseTuple;
    }
}

