/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common.functions;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.EdgeFactory;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.GraphHeadFactory;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.api.entities.VertexFactory;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.impl.operators.matching.common.query.QueryHandler;
import org.gradoop.flink.model.impl.operators.matching.common.query.Step;
import org.gradoop.flink.model.impl.operators.matching.common.query.TraversalCode;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.Embedding;

public class ElementsFromEmbedding
extends RichFlatMapFunction<Tuple1<Embedding<GradoopId>>, Element> {
    private final Map<Integer, Step> edgeToStep;
    private final GraphHeadFactory<? extends GraphHead> graphHeadFactory;
    private final VertexFactory<? extends Vertex> vertexFactory;
    private final EdgeFactory<? extends Edge> edgeFactory;
    private final Map<Long, String> queryVertexMapping;
    private final Map<Long, String> queryEdgeMapping;
    private Map<PropertyValue, PropertyValue> reuseVariableMapping;

    public ElementsFromEmbedding(TraversalCode traversalCode, GraphHeadFactory<? extends GraphHead> graphHeadFactory, VertexFactory<? extends Vertex> vertexFactory, EdgeFactory<? extends Edge> edgeFactory, QueryHandler query) {
        this.graphHeadFactory = graphHeadFactory;
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
        this.queryVertexMapping = query.getVertices().stream().collect(Collectors.toMap(v -> v.getId(), v -> v.getVariable()));
        this.queryEdgeMapping = query.getEdges().stream().collect(Collectors.toMap(e -> e.getId(), e -> e.getVariable()));
        List<Step> steps = traversalCode.getSteps();
        this.edgeToStep = Maps.newHashMapWithExpectedSize((int)steps.size());
        for (Step step : steps) {
            this.edgeToStep.put((int)step.getVia(), step);
        }
    }

    public void open(Configuration conf) {
        this.reuseVariableMapping = new HashMap<PropertyValue, PropertyValue>();
    }

    public void flatMap(Tuple1<Embedding<GradoopId>> embedding, Collector<Element> out) throws Exception {
        int i;
        GradoopId[] vertexMapping = (GradoopId[])((Embedding)((Object)embedding.f0)).getVertexMapping();
        GradoopId[] edgeMapping = (GradoopId[])((Embedding)((Object)embedding.f0)).getEdgeMapping();
        GraphHead graphHead = this.graphHeadFactory.createGraphHead();
        for (i = 0; i < vertexMapping.length; ++i) {
            if (!this.isProcessed(vertexMapping, i)) {
                Vertex v = this.vertexFactory.initVertex(vertexMapping[i]);
                v.addGraphId(graphHead.getId());
                out.collect((Object)v);
            }
            this.reuseVariableMapping.put(PropertyValue.create((Object)this.queryVertexMapping.get(i)), PropertyValue.create((Object)vertexMapping[i]));
        }
        for (i = 0; i < edgeMapping.length; ++i) {
            if (!this.isProcessed(edgeMapping, i)) {
                Step s = this.edgeToStep.get(i);
                GradoopId sourceId = s.isOutgoing() ? vertexMapping[(int)s.getFrom()] : vertexMapping[(int)s.getTo()];
                GradoopId targetId = s.isOutgoing() ? vertexMapping[(int)s.getTo()] : vertexMapping[(int)s.getFrom()];
                Edge e = this.edgeFactory.initEdge(edgeMapping[i], sourceId, targetId);
                e.addGraphId(graphHead.getId());
                out.collect((Object)e);
            }
            this.reuseVariableMapping.put(PropertyValue.create((Object)this.queryEdgeMapping.get(i)), PropertyValue.create((Object)edgeMapping[i]));
        }
        graphHead.setProperty("__variable_mapping", this.reuseVariableMapping);
        out.collect((Object)graphHead);
    }

    private boolean isProcessed(GradoopId[] mapping, int i) {
        for (int j = 0; j < i; ++j) {
            if (!mapping[j].equals((Object)mapping[i])) continue;
            return true;
        }
        return false;
    }
}

