/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common.functions;

import org.apache.flink.api.common.functions.RichFlatJoinFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.impl.operators.matching.common.query.QueryHandler;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.IdWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.TripleWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.TripleWithSourceEdgeCandidates;

@FunctionAnnotation.ForwardedFieldsSecond(value={"f0;f1;f2->f3"})
public class MatchingPairs
extends RichFlatJoinFunction<IdWithCandidates<GradoopId>, TripleWithCandidates<GradoopId>, TripleWithSourceEdgeCandidates<GradoopId>> {
    private static final long serialVersionUID = 42L;
    private final String query;
    private transient QueryHandler queryHandler;
    private final TripleWithSourceEdgeCandidates<GradoopId> reuseTuple;

    public MatchingPairs(String query) {
        this.query = query;
        this.reuseTuple = new TripleWithSourceEdgeCandidates();
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.queryHandler = new QueryHandler(this.query);
    }

    public void join(IdWithCandidates<GradoopId> sourceVertex, TripleWithCandidates<GradoopId> edge, Collector<TripleWithSourceEdgeCandidates<GradoopId>> collector) throws Exception {
        boolean[] sourceCandidates = sourceVertex.getCandidates();
        boolean[] edgeCandidates = edge.getCandidates();
        boolean[] newSourceCandidates = new boolean[sourceCandidates.length];
        boolean[] newEdgeCandidates = new boolean[edgeCandidates.length];
        boolean pairStillValid = false;
        for (int eQ = 0; eQ < edgeCandidates.length; ++eQ) {
            int vQ;
            if (!edgeCandidates[eQ] || !sourceCandidates[vQ = this.queryHandler.getEdgeById(Long.valueOf(eQ)).getSourceVertexId().intValue()]) continue;
            newSourceCandidates[vQ] = true;
            newEdgeCandidates[eQ] = true;
            pairStillValid = true;
        }
        if (pairStillValid) {
            this.reuseTuple.setEdgeId(edge.getEdgeId());
            this.reuseTuple.setSourceId(edge.getSourceId());
            this.reuseTuple.setSourceCandidates(newSourceCandidates);
            this.reuseTuple.setTargetId(edge.getTargetId());
            this.reuseTuple.setEdgeCandidates(newEdgeCandidates);
            collector.collect(this.reuseTuple);
        }
    }
}

