/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common.functions;

import org.apache.flink.api.common.functions.RichFlatJoinFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.impl.operators.matching.common.query.QueryHandler;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.IdWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.TripleWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.TripleWithSourceEdgeCandidates;
import org.s1ck.gdl.model.Edge;

@FunctionAnnotation.ForwardedFieldsFirst(value={"f0;f1;f3->f2"})
public class MatchingTriples
extends RichFlatJoinFunction<TripleWithSourceEdgeCandidates<GradoopId>, IdWithCandidates<GradoopId>, TripleWithCandidates<GradoopId>> {
    private static final long serialVersionUID = 42L;
    private final String query;
    private transient QueryHandler queryHandler;
    private final TripleWithCandidates<GradoopId> reuseTriple;

    public MatchingTriples(String query) {
        this.query = query;
        this.reuseTriple = new TripleWithCandidates();
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.queryHandler = new QueryHandler(this.query);
    }

    public void join(TripleWithSourceEdgeCandidates<GradoopId> pair, IdWithCandidates<GradoopId> target, Collector<TripleWithCandidates<GradoopId>> collector) throws Exception {
        boolean[] edgeCandidates = pair.getEdgeCandidates();
        boolean[] newEdgeCandidates = new boolean[edgeCandidates.length];
        boolean edgeStillValid = false;
        for (int i = 0; i < edgeCandidates.length; ++i) {
            if (!edgeCandidates[i]) continue;
            Edge e = this.queryHandler.getEdgeById(Long.valueOf(i));
            if (!pair.getSourceCandidates()[e.getSourceVertexId().intValue()] || !target.getCandidates()[e.getTargetVertexId().intValue()]) continue;
            newEdgeCandidates[i] = true;
            edgeStillValid = true;
        }
        if (edgeStillValid) {
            this.reuseTriple.setEdgeId(pair.getEdgeId());
            this.reuseTriple.setSourceId(pair.getSourceId());
            this.reuseTriple.setTargetId(target.getId());
            this.reuseTriple.setCandidates(newEdgeCandidates);
            collector.collect(this.reuseTriple);
        }
    }
}

