/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common.matching;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gradoop.common.model.api.entities.Element;
import org.s1ck.gdl.model.GraphElement;

public class ElementMatcher {
    public static <EL1 extends Element, EL2 extends GraphElement> boolean matchAll(EL1 dbElement, Collection<EL2> queryElements, String defaultLabel) {
        GraphElement queryElement;
        boolean match = false;
        Iterator<EL2> iterator = queryElements.iterator();
        while (iterator.hasNext() && !(match = ElementMatcher.match(dbElement, queryElement = (GraphElement)iterator.next(), defaultLabel))) {
        }
        return match;
    }

    public static <EL1 extends Element, EL2 extends GraphElement> List<Long> getMatches(EL1 dbElement, Collection<EL2> queryElements, String defaultLabel) {
        ArrayList matches = Lists.newArrayListWithCapacity((int)queryElements.size());
        for (GraphElement queryElement : queryElements) {
            if (!ElementMatcher.match(dbElement, queryElement, defaultLabel)) continue;
            matches.add(queryElement.getId());
        }
        return matches;
    }

    public static <EL1 extends Element, EL2 extends GraphElement> boolean match(EL1 dbElement, EL2 queryElement, String defaultLabel) {
        boolean match = false;
        if (queryElement.getLabel().equals(dbElement.getLabel()) || queryElement.getLabel().equals(defaultLabel)) {
            match = true;
        }
        if (match && queryElement.getProperties() != null) {
            Iterator queryProperties = queryElement.getProperties().entrySet().iterator();
            while (match && queryProperties.hasNext()) {
                Map.Entry queryProperty = queryProperties.next();
                if (!dbElement.hasProperty((String)queryProperty.getKey())) {
                    match = false;
                    break;
                }
                match = dbElement.getPropertyValue((String)queryProperty.getKey()).getObject().equals(queryProperty.getValue());
            }
        }
        return match;
    }
}

