/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common.query;

import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.HashSet;
import org.gradoop.flink.model.impl.operators.matching.common.query.QueryHandler;
import org.gradoop.flink.model.impl.operators.matching.common.query.RootedTraverser;
import org.gradoop.flink.model.impl.operators.matching.common.query.Step;
import org.gradoop.flink.model.impl.operators.matching.common.query.TraversalCode;
import org.s1ck.gdl.model.Edge;

public class DFSTraverser
implements RootedTraverser {
    private QueryHandler queryHandler;

    @Override
    public TraversalCode traverse() {
        return this.traverse(this.queryHandler.getVertices().iterator().next().getId());
    }

    @Override
    public void setQueryHandler(QueryHandler queryHandler) {
        this.queryHandler = queryHandler;
    }

    @Override
    public QueryHandler getQueryHandler() {
        return this.queryHandler;
    }

    @Override
    public TraversalCode traverse(long rootVertex) {
        HashSet vertexVisited = Sets.newHashSetWithExpectedSize((int)this.queryHandler.getVertexCount());
        HashSet edgeVisited = Sets.newHashSetWithExpectedSize((int)this.queryHandler.getEdgeCount());
        TraversalCode traversalCode = new TraversalCode();
        long current = rootVertex;
        vertexVisited.add(current);
        ArrayDeque<Edge> edgeStack = new ArrayDeque<Edge>(this.queryHandler.getEdgesByVertexId(current));
        while (!edgeStack.isEmpty()) {
            Edge edge = (Edge)edgeStack.removeLast();
            long via = edge.getId();
            if (edgeVisited.contains(via)) continue;
            long source = edge.getSourceVertexId();
            long target = edge.getTargetVertexId();
            if (current != source && current != target) {
                current = vertexVisited.contains(source) ? source : target;
            }
            boolean isOutgoing = current == source;
            long from = isOutgoing ? source : target;
            long to = isOutgoing ? target : source;
            traversalCode.add(new Step(from, via, to, isOutgoing));
            boolean visitedFrom = vertexVisited.contains(from);
            boolean visitedTo = vertexVisited.contains(to);
            if (!visitedFrom || !visitedTo) {
                current = visitedFrom ? to : from;
                edgeStack.addAll(this.queryHandler.getEdgesByVertexId(current));
            }
            vertexVisited.add(current);
            edgeVisited.add(via);
        }
        return traversalCode;
    }
}

