/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradoop.flink.model.impl.operators.matching.common.query.QueryHandler;
import org.s1ck.gdl.model.Vertex;

public class GraphMetrics {
    public static int getDiameter(QueryHandler graph) {
        return Collections.max(GraphMetrics.getEccentricity(graph).values());
    }

    public static int getRadius(QueryHandler graph) {
        return Collections.min(GraphMetrics.getEccentricity(graph).values());
    }

    public static Map<Long, Integer> getEccentricity(QueryHandler graph) {
        HashMap ecc = Maps.newHashMap();
        for (Vertex v : graph.getVertices()) {
            ecc.put(v.getId(), GraphMetrics.getEccentricity(graph, v));
        }
        return ecc;
    }

    public static Integer getEccentricity(QueryHandler graph, Vertex v) {
        HashMap distances = Maps.newHashMap();
        LinkedList<Long> queue = new LinkedList<Long>();
        queue.add(v.getId());
        distances.put(v.getId(), 0);
        int ecc = 0;
        while (!queue.isEmpty()) {
            Long current = (Long)queue.poll();
            Integer currentDistance = (Integer)distances.get(current);
            ecc = currentDistance > ecc ? currentDistance : ecc;
            for (Long neighbor : graph.getNeighborIds(current)) {
                if (distances.containsKey(neighbor)) continue;
                distances.put(neighbor, currentDistance + 1);
                queue.add(neighbor);
            }
        }
        return ecc;
    }

    public static Map<Integer, Set<String>> getComponents(QueryHandler graph) {
        int nextComponentId = 0;
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(graph.getVertices());
        HashMap<Integer, Set<String>> mapping = new HashMap<Integer, Set<String>>();
        while (vertices.size() != 0) {
            int componentId = nextComponentId++;
            ArrayList nextVertices = Lists.newArrayList((Object[])new Long[]{((Vertex)vertices.remove(0)).getId()});
            mapping.put(componentId, Sets.newHashSet((Object[])new String[]{graph.getVertexById((Long)nextVertices.get(0)).getVariable()}));
            while (nextVertices.size() != 0) {
                ArrayList currentVertices = nextVertices;
                nextVertices = new ArrayList();
                for (Long vertexId : currentVertices) {
                    nextVertices.addAll(graph.getEdges().stream().filter(edge -> edge.getSourceVertexId().equals(vertexId) || edge.getTargetVertexId().equals(vertexId)).map(edge -> edge.getSourceVertexId().equals(vertexId) ? edge.getTargetVertexId() : edge.getSourceVertexId()).filter(id -> vertices.removeIf(v -> v.getId() == id.longValue())).collect(Collectors.toList()));
                }
                ((Set)mapping.get(componentId)).addAll(nextVertices.stream().map(id -> graph.getVertexById((Long)id).getVariable()).collect(Collectors.toList()));
            }
        }
        return mapping;
    }
}

