/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.gradoop.flink.model.impl.operators.matching.common.query.GraphMetrics;
import org.gradoop.flink.model.impl.operators.matching.common.query.Triple;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.CNF;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.QueryPredicate;
import org.s1ck.gdl.GDLHandler;
import org.s1ck.gdl.model.Edge;
import org.s1ck.gdl.model.Element;
import org.s1ck.gdl.model.GraphElement;
import org.s1ck.gdl.model.Vertex;
import org.s1ck.gdl.model.predicates.Predicate;

public class QueryHandler {
    private final GDLHandler gdlHandler;
    private Integer diameter;
    private Integer radius;
    private Map<Integer, Set<String>> components;
    private Map<Long, Vertex> idToVertexCache;
    private Map<Long, Edge> idToEdgeCache;
    private Map<String, Set<Vertex>> labelToVertexCache;
    private Map<String, Set<Edge>> labelToEdgeCache;
    private Map<Long, Set<Edge>> sourceIdToEdgeCache;
    private Map<Long, Set<Edge>> targetIdToEdgeCache;
    private Map<String, Edge> edgeCache;
    private Map<String, Vertex> vertexCache;

    public QueryHandler(String gdlString) {
        this.gdlHandler = new GDLHandler.Builder().setDefaultGraphLabel("").setDefaultVertexLabel("").setDefaultEdgeLabel("").buildFromString(gdlString);
        this.edgeCache = this.gdlHandler.getEdgeCache(true, true);
        this.vertexCache = this.gdlHandler.getVertexCache(true, true);
    }

    public Collection<Vertex> getVertices() {
        return this.gdlHandler.getVertices();
    }

    public Collection<Edge> getEdges() {
        return this.gdlHandler.getEdges();
    }

    public Collection<Triple> getTriples() {
        return this.getEdges().stream().map(e -> new Triple(this.getVertexById(e.getSourceVertexId()), (Edge)e, this.getVertexById(e.getTargetVertexId()))).collect(Collectors.toList());
    }

    public Set<String> getAllVariables() {
        return Sets.union(this.getVertexVariables(), this.getEdgeVariables());
    }

    public Set<String> getVertexVariables() {
        return this.vertexCache.keySet();
    }

    public Set<String> getEdgeVariables() {
        return this.edgeCache.keySet();
    }

    public CNF getPredicates() {
        if (this.gdlHandler.getPredicates().isPresent()) {
            return QueryPredicate.createFrom((Predicate)this.gdlHandler.getPredicates().get()).asCNF();
        }
        return new CNF();
    }

    public int getVertexCount() {
        return this.getVertices().size();
    }

    public int getEdgeCount() {
        return this.getEdges().size();
    }

    public boolean isSingleVertexGraph() {
        return this.getVertexCount() == 1 && this.getEdgeCount() == 0;
    }

    public int getDiameter() {
        if (this.diameter == null) {
            this.diameter = GraphMetrics.getDiameter(this);
        }
        return this.diameter;
    }

    public int getRadius() {
        if (this.radius == null) {
            this.radius = GraphMetrics.getRadius(this);
        }
        return this.radius;
    }

    public Map<Integer, Set<String>> getComponents() {
        if (this.components == null) {
            this.components = GraphMetrics.getComponents(this);
        }
        return this.components;
    }

    public boolean isVertex(String variable) {
        return this.vertexCache.containsKey(variable);
    }

    public boolean isEdge(String variable) {
        return this.edgeCache.containsKey(variable);
    }

    public Vertex getVertexById(Long id) {
        if (this.idToVertexCache == null) {
            this.idToVertexCache = this.initCache(this.getVertices(), Element::getId, Function.identity());
        }
        return this.idToVertexCache.get(id);
    }

    public Edge getEdgeById(Long id) {
        if (this.idToEdgeCache == null) {
            this.idToEdgeCache = this.initCache(this.getEdges(), Element::getId, Function.identity());
        }
        return this.idToEdgeCache.get(id);
    }

    public Vertex getVertexByVariable(String variable) {
        return this.vertexCache.get(variable);
    }

    public Edge getEdgeByVariable(String variable) {
        return this.edgeCache.get(variable);
    }

    public Collection<Vertex> getVerticesByLabel(String label) {
        if (this.labelToVertexCache == null) {
            this.labelToVertexCache = this.initSetCache(this.getVertices(), Element::getLabel, Function.identity());
        }
        return this.labelToVertexCache.get(label);
    }

    public Collection<Edge> getEdgesByLabel(String label) {
        if (this.labelToEdgeCache == null) {
            this.labelToEdgeCache = this.initSetCache(this.getEdges(), Element::getLabel, Function.identity());
        }
        return this.labelToEdgeCache.get(label);
    }

    public Collection<Edge> getEdgesByVertexId(Long vertexId) {
        ArrayList result = Lists.newArrayList();
        if (this.getEdgesBySourceVertexId(vertexId) != null) {
            result.addAll(this.getEdgesBySourceVertexId(vertexId));
        }
        if (this.getEdgesByTargetVertexId(vertexId) != null) {
            result.addAll(this.getEdgesByTargetVertexId(vertexId));
        }
        return result;
    }

    public Collection<Edge> getEdgesBySourceVertexId(Long vertexId) {
        if (this.sourceIdToEdgeCache == null) {
            this.sourceIdToEdgeCache = this.initSetCache(this.getEdges(), Edge::getSourceVertexId, Function.identity());
        }
        return this.sourceIdToEdgeCache.get(vertexId);
    }

    public Collection<Long> getEdgeIdsBySourceVertexId(Long vertexId) {
        return this.getIds(this.getEdgesBySourceVertexId(vertexId));
    }

    public Collection<Edge> getEdgesByTargetVertexId(Long vertexId) {
        if (this.targetIdToEdgeCache == null) {
            this.targetIdToEdgeCache = this.initSetCache(this.getEdges(), Edge::getTargetVertexId, Function.identity());
        }
        return this.targetIdToEdgeCache.get(vertexId);
    }

    public Collection<Long> getEdgeIdsByTargetVertexId(Long vertexId) {
        return this.getIds(this.getEdgesByTargetVertexId(vertexId));
    }

    public Collection<Edge> getPredecessors(Long edgeId) {
        Collection<Edge> predecessors = this.getEdgesByTargetVertexId(this.getEdgeById(edgeId).getSourceVertexId());
        return predecessors != null ? Lists.newArrayList(predecessors) : Lists.newArrayList();
    }

    public Collection<Edge> getSuccessors(Long edgeId) {
        Collection<Edge> successors = this.getEdgesBySourceVertexId(this.getEdgeById(edgeId).getTargetVertexId());
        return successors != null ? Lists.newArrayList(successors) : Lists.newArrayList();
    }

    public Collection<Long> getPredecessorIds(Long edgeId) {
        return this.getIds(this.getPredecessors(edgeId));
    }

    public Collection<Long> getSuccessorIds(Long edgeId) {
        return this.getIds(this.getSuccessors(edgeId));
    }

    public Collection<Vertex> getNeighbors(Long vertexId) {
        Collection<Edge> incomingEdges;
        HashSet neighbors = Sets.newHashSet();
        Collection<Edge> outgoingEdges = this.getEdgesBySourceVertexId(vertexId);
        if (outgoingEdges != null) {
            for (Edge edge : outgoingEdges) {
                neighbors.add(this.getVertexById(edge.getTargetVertexId()));
            }
        }
        if ((incomingEdges = this.getEdgesByTargetVertexId(vertexId)) != null) {
            for (Edge edge : incomingEdges) {
                neighbors.add(this.getVertexById(edge.getSourceVertexId()));
            }
        }
        return neighbors;
    }

    public Collection<Long> getNeighborIds(Long vertexId) {
        HashSet neighbors = Sets.newHashSet();
        for (Vertex vertex : this.getNeighbors(vertexId)) {
            neighbors.add(vertex.getId());
        }
        return neighbors;
    }

    public Map<String, String> getLabelsForVariables(Collection<String> variables) {
        return variables.stream().filter(var -> this.isEdge((String)var) || this.isVertex((String)var)).map(var -> {
            if (this.isEdge((String)var)) {
                return Pair.of((Object)var, (Object)this.getEdgeByVariable((String)var).getLabel());
            }
            return Pair.of((Object)var, (Object)this.getVertexByVariable((String)var).getLabel());
        }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    public Map<String, Pair<String, String>> getSourceTargetVariables() {
        return this.getEdges().stream().map(e -> Pair.of((Object)e.getVariable(), (Object)Pair.of((Object)this.getVertexById(e.getSourceVertexId()).getVariable(), (Object)this.getVertexById(e.getTargetVertexId()).getVariable()))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    private <EL extends GraphElement> Collection<Long> getIds(Collection<EL> elements) {
        ArrayList ids = null;
        if (elements != null) {
            ids = Lists.newArrayListWithCapacity((int)elements.size());
            for (GraphElement el : elements) {
                ids.add(el.getId());
            }
        }
        return ids;
    }

    public Collection<Vertex> getCenterVertices() {
        ArrayList result = Lists.newArrayList();
        for (Long vId : this.getCentralVertexIds()) {
            result.add(this.getVertexById(vId));
        }
        return result;
    }

    public Vertex getCenterVertex() {
        return this.getCenterVertices().iterator().next();
    }

    public Collection<Long> getCentralVertexIds() {
        Map<Long, Integer> eccMap = GraphMetrics.getEccentricity(this);
        Integer min = Collections.min(eccMap.values());
        ArrayList result = Lists.newArrayList();
        for (Map.Entry<Long, Integer> eccEntry : eccMap.entrySet()) {
            if (!eccEntry.getValue().equals(min)) continue;
            result.add(eccEntry.getKey());
        }
        return result;
    }

    private <EL, KT, VT> Map<KT, VT> initCache(Collection<EL> elements, Function<EL, KT> keySelector, Function<EL, VT> valueSelector) {
        return elements.stream().collect(Collectors.toMap(keySelector, valueSelector));
    }

    private <EL, KT, VT> Map<KT, Set<VT>> initSetCache(Collection<EL> elements, Function<EL, KT> keySelector, Function<EL, VT> valueSelector) {
        return elements.stream().collect(Collectors.groupingBy(keySelector, Collectors.mapping(valueSelector, Collectors.toSet())));
    }

    public void updateGeneratedVariableNames(Function<String, String> renameFunction) {
        String variable;
        Set generatedEdgeVariables = this.gdlHandler.getEdgeCache(false, true).keySet();
        Set generatedVertexVariables = this.gdlHandler.getVertexCache(false, true).keySet();
        HashMap<String, Vertex> newVertexCache = new HashMap<String, Vertex>();
        HashMap<String, Edge> newEdgeCache = new HashMap<String, Edge>();
        for (Vertex vertex : this.getVertices()) {
            variable = vertex.getVariable();
            if (generatedVertexVariables.contains(variable)) {
                vertex.setVariable(renameFunction.apply(variable));
            }
            newVertexCache.put(vertex.getVariable(), vertex);
        }
        for (Edge edge : this.getEdges()) {
            variable = edge.getVariable();
            if (generatedEdgeVariables.contains(variable)) {
                edge.setVariable(renameFunction.apply(variable));
            }
            newEdgeCache.put(edge.getVariable(), edge);
        }
        this.vertexCache = Collections.unmodifiableMap(newVertexCache);
        this.edgeCache = Collections.unmodifiableMap(newEdgeCache);
    }
}

