/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common.query.predicates;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradoop.common.model.api.entities.GraphElement;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.CNFElement;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.PredicateCollection;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingMetaData;

public class CNF
extends PredicateCollection<CNFElement> {
    public CNF() {
        this.predicates = new ArrayList();
    }

    public CNF(List<CNFElement> predicates) {
        this.predicates = predicates;
    }

    public CNF(CNF copyValue) {
        this(new ArrayList<CNFElement>(copyValue.getPredicates()));
    }

    public CNF and(CNF other) {
        other.getPredicates().stream().filter(predicate -> !this.predicates.contains(predicate)).forEach(this::addPredicate);
        return this;
    }

    public CNF or(CNF other) {
        ArrayList<CNFElement> newPredicates = new ArrayList<CNFElement>();
        for (CNFElement p : this.predicates) {
            for (CNFElement q : other.getPredicates()) {
                CNFElement newCNFElement = new CNFElement();
                newCNFElement.addPredicates(p.getPredicates());
                newCNFElement.addPredicates(q.getPredicates());
                newPredicates.add(newCNFElement);
            }
        }
        this.predicates = newPredicates;
        return this;
    }

    @Override
    public boolean evaluate(Embedding embedding, EmbeddingMetaData metaData) {
        for (CNFElement element : this.predicates) {
            if (element.evaluate(embedding, metaData)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean evaluate(GraphElement graphElement) {
        for (CNFElement element : this.predicates) {
            if (element.evaluate(graphElement)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String operatorName() {
        return "AND";
    }

    public CNF getSubCNF(String variable) {
        HashSet<String> variables = new HashSet<String>(1);
        variables.add(variable);
        return this.getSubCNF(variables);
    }

    public CNF getSubCNF(Set<String> variables) {
        List<CNFElement> filtered = this.predicates.stream().filter(p -> variables.containsAll(p.getVariables())).collect(Collectors.toList());
        return new CNF(filtered);
    }

    public CNF removeSubCNF(String variable) {
        HashSet<String> variables = new HashSet<String>(1);
        variables.add(variable);
        return this.removeSubCNF(variables);
    }

    public CNF removeSubCNF(Set<String> variables) {
        Map<Boolean, List<CNFElement>> filtered = this.predicates.stream().collect(Collectors.partitioningBy(p -> variables.containsAll(p.getVariables())));
        this.predicates = filtered.get(false);
        return new CNF(filtered.get(true));
    }

    @Override
    public Set<String> getVariables() {
        HashSet<String> variables = new HashSet<String>();
        for (CNFElement cnfElement : this.predicates) {
            variables.addAll(cnfElement.getVariables());
        }
        return variables;
    }

    @Override
    public Set<String> getPropertyKeys(String variable) {
        HashSet<String> properties = new HashSet<String>();
        for (CNFElement cnfElement : this.predicates) {
            properties.addAll(cnfElement.getPropertyKeys(variable));
        }
        return properties;
    }
}

