/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common.query.predicates;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradoop.common.model.api.entities.GraphElement;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingMetaData;

public abstract class PredicateCollection<P>
implements Iterable<P>,
Serializable {
    protected List<P> predicates;

    public List<P> getPredicates() {
        return this.predicates;
    }

    public void setPredicates(List<P> predicates) {
        this.predicates = predicates;
    }

    public void addPredicate(P predicate) {
        this.predicates.add(predicate);
    }

    public void addPredicates(List<P> predicateList) {
        this.predicates.addAll(predicateList);
    }

    public int size() {
        return this.predicates.size();
    }

    public abstract boolean evaluate(Embedding var1, EmbeddingMetaData var2);

    public abstract boolean evaluate(GraphElement var1);

    public abstract Set<String> getVariables();

    public abstract Set<String> getPropertyKeys(String var1);

    public abstract String operatorName();

    @Override
    public Iterator<P> iterator() {
        return this.predicates.iterator();
    }

    public String toString() {
        return "(" + this.predicates.stream().map(Object::toString).collect(Collectors.joining(" " + this.operatorName() + " ")) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredicateCollection predicateCollection = (PredicateCollection)o;
        return Objects.equals(this.predicates, predicateCollection.predicates);
    }

    public int hashCode() {
        return this.predicates != null ? this.predicates.hashCode() : 0;
    }
}

