/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common.query.predicates.booleans;

import java.util.Objects;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.CNF;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.CNFElement;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.QueryPredicate;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.expressions.ComparisonExpression;
import org.s1ck.gdl.model.comparables.ComparableExpression;
import org.s1ck.gdl.model.predicates.Predicate;
import org.s1ck.gdl.model.predicates.booleans.And;
import org.s1ck.gdl.model.predicates.booleans.Not;
import org.s1ck.gdl.model.predicates.booleans.Or;
import org.s1ck.gdl.model.predicates.expressions.Comparison;
import org.s1ck.gdl.utils.Comparator;

public class NotPredicate
extends QueryPredicate {
    private final Not not;

    public NotPredicate(Not not) {
        this.not = not;
    }

    @Override
    public CNF asCNF() {
        Predicate expression = this.not.getArguments()[0];
        if (expression.getClass() == Comparison.class) {
            CNF cnf = new CNF();
            CNFElement cnfElement = new CNFElement();
            cnfElement.addPredicate(new ComparisonExpression(this.invertComparison((Comparison)expression)));
            cnf.addPredicate(cnfElement);
            return cnf;
        }
        if (expression.getClass() == Not.class) {
            return QueryPredicate.createFrom(expression.getArguments()[0]).asCNF();
        }
        if (expression.getClass() == And.class) {
            Predicate[] otherArguments = expression.getArguments();
            Or or = new Or((Predicate)new Not(otherArguments[0]), (Predicate)new Not(otherArguments[0]));
            return QueryPredicate.createFrom((Predicate)or).asCNF();
        }
        if (expression.getClass() == Or.class) {
            Predicate[] otherArguments = expression.getArguments();
            And and = new And((Predicate)new Not(otherArguments[0]), (Predicate)new Not(otherArguments[1]));
            return QueryPredicate.createFrom((Predicate)and).asCNF();
        }
        Predicate[] otherArguments = expression.getArguments();
        Or or = new Or((Predicate)new And(otherArguments[0], otherArguments[1]), (Predicate)new And((Predicate)new Not(otherArguments[0]), (Predicate)new Not(otherArguments[0])));
        return QueryPredicate.createFrom((Predicate)or).asCNF();
    }

    private Comparison invertComparison(Comparison comparison) {
        ComparableExpression[] arguments = comparison.getComparableExpressions();
        Comparator op = comparison.getComparator();
        return new Comparison(arguments[0], op.getInverse(), arguments[1]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotPredicate that = (NotPredicate)o;
        return Objects.equals(this.not, that.not);
    }

    public int hashCode() {
        return this.not != null ? this.not.hashCode() : 0;
    }
}

