/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common.query.predicates.comparables;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.gradoop.common.model.api.entities.GraphElement;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.QueryComparable;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingMetaData;
import org.s1ck.gdl.model.comparables.PropertySelector;

public class PropertySelectorComparable
extends QueryComparable {
    private final PropertySelector propertySelector;

    public PropertySelectorComparable(PropertySelector propertySelector) {
        this.propertySelector = propertySelector;
    }

    public String getVariable() {
        return this.propertySelector.getVariable();
    }

    public String getPropertyKey() {
        return this.propertySelector.getPropertyName();
    }

    @Override
    public PropertyValue evaluate(Embedding embedding, EmbeddingMetaData metaData) {
        int propertyColumn = metaData.getPropertyColumn(this.propertySelector.getVariable(), this.propertySelector.getPropertyName());
        return embedding.getProperty(propertyColumn);
    }

    @Override
    public PropertyValue evaluate(GraphElement element) {
        if (this.propertySelector.getPropertyName().equals("__label__")) {
            return PropertyValue.create((Object)element.getLabel());
        }
        return element.hasProperty(this.propertySelector.getPropertyName()) ? element.getPropertyValue(this.propertySelector.getPropertyName()) : PropertyValue.NULL_VALUE;
    }

    @Override
    public Set<String> getPropertyKeys(String variable) {
        return variable.equals(this.propertySelector.getVariable()) ? Sets.newHashSet((Object[])new String[]{this.propertySelector.getPropertyName()}) : new HashSet(0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertySelectorComparable that = (PropertySelectorComparable)o;
        return Objects.equals(this.propertySelector, that.propertySelector);
    }

    public int hashCode() {
        return this.propertySelector != null ? this.propertySelector.hashCode() : 0;
    }
}

