/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common.query.predicates.expressions;

import java.util.Objects;
import java.util.Set;
import org.gradoop.common.model.api.entities.GraphElement;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.CNF;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.CNFElement;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.QueryComparable;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.QueryPredicate;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingMetaData;
import org.s1ck.gdl.model.predicates.expressions.Comparison;
import org.s1ck.gdl.utils.Comparator;

public class ComparisonExpression
extends QueryPredicate {
    private final Comparison comparison;

    public ComparisonExpression(Comparison comparison) {
        this.comparison = comparison;
    }

    public QueryComparable getLhs() {
        return QueryComparable.createFrom(this.comparison.getComparableExpressions()[0]);
    }

    public QueryComparable getRhs() {
        return QueryComparable.createFrom(this.comparison.getComparableExpressions()[1]);
    }

    public Comparator getComparator() {
        return this.comparison.getComparator();
    }

    public boolean evaluate(Embedding embedding, EmbeddingMetaData metaData) {
        PropertyValue lhsValue = this.getLhs().evaluate(embedding, metaData);
        PropertyValue rhsValue = this.getRhs().evaluate(embedding, metaData);
        return this.compare(lhsValue, rhsValue);
    }

    public boolean evaluate(GraphElement element) {
        PropertyValue lhsValue = this.getLhs().evaluate(element);
        PropertyValue rhsValue = this.getRhs().evaluate(element);
        return this.compare(lhsValue, rhsValue);
    }

    private boolean compare(PropertyValue lhsValue, PropertyValue rhsValue) {
        try {
            int result = lhsValue.compareTo(rhsValue);
            return this.comparison.getComparator() == Comparator.EQ && result == 0 || this.comparison.getComparator() == Comparator.NEQ && result != 0 || this.comparison.getComparator() == Comparator.LT && result == -1 || this.comparison.getComparator() == Comparator.GT && result == 1 || this.comparison.getComparator() == Comparator.LTE && result <= 0 || this.comparison.getComparator() == Comparator.GTE && result >= 0;
        }
        catch (IllegalArgumentException e) {
            return this.comparison.getComparator() == Comparator.NEQ;
        }
    }

    public Set<String> getVariables() {
        return this.comparison.getVariables();
    }

    public Set<String> getPropertyKeys(String variable) {
        Set<String> properties = this.getLhs().getPropertyKeys(variable);
        properties.addAll(this.getRhs().getPropertyKeys(variable));
        return properties;
    }

    @Override
    public CNF asCNF() {
        CNF cnf = new CNF();
        CNFElement cnfElement = new CNFElement();
        cnfElement.addPredicate(this);
        cnf.addPredicate(cnfElement);
        return cnf;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparisonExpression that = (ComparisonExpression)o;
        return Objects.equals(this.comparison, that.comparison);
    }

    public int hashCode() {
        return this.comparison != null ? this.comparison.hashCode() : 0;
    }

    public String toString() {
        return this.comparison.toString();
    }
}

