/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common.statistics;

import java.util.Collections;
import java.util.Map;

public class GraphStatistics {
    private long vertexCount;
    private long edgeCount;
    private Map<String, Long> vertexCountByLabel;
    private Map<String, Long> edgeCountByLabel;
    private Map<String, Map<String, Long>> edgeCountBySourceVertexAndEdgeLabel;
    private Map<String, Map<String, Long>> edgeCountByTargetVertexAndEdgeLabel;
    private long distinctSourceVertexCount;
    private long distinctTargetVertexCount;
    private Map<String, Long> distinctSourceVertexCountByEdgeLabel;
    private Map<String, Long> distinctTargetVertexCountByEdgeLabel;
    private Map<String, Map<String, Long>> distinctEdgePropertiesByLabel;
    private Map<String, Map<String, Long>> distinctVertexPropertiesByLabel;
    private Map<String, Long> distinctEdgeProperties;
    private Map<String, Long> distinctVertexProperties;

    public GraphStatistics(long vertexCount, long edgeCount, long distinctSourceVertexCount, long distinctTargetVertexCount) {
        this(vertexCount, edgeCount, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), distinctSourceVertexCount, distinctTargetVertexCount, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    GraphStatistics(long vertexCount, long edgeCount, Map<String, Long> vertexCountByLabel, Map<String, Long> edgeCountByLabel, Map<String, Map<String, Long>> edgeCountBySourceVertexAndEdgeLabel, Map<String, Map<String, Long>> edgeCountByTargetVertexAndEdgeLabel, long distinctSourceVertexCount, long distinctTargetVertexCount, Map<String, Long> distinctSourceVertexCountByEdgeLabel, Map<String, Long> distinctTargetVertexCountByEdgeLabel, Map<String, Map<String, Long>> distinctEdgePropertiesByLabel, Map<String, Map<String, Long>> distinctVertexPropertiesByLabel, Map<String, Long> distinctEdgeProperties, Map<String, Long> distinctVertexProperties) {
        this.vertexCount = vertexCount;
        this.edgeCount = edgeCount;
        this.vertexCountByLabel = vertexCountByLabel;
        this.edgeCountByLabel = edgeCountByLabel;
        this.edgeCountBySourceVertexAndEdgeLabel = edgeCountBySourceVertexAndEdgeLabel;
        this.edgeCountByTargetVertexAndEdgeLabel = edgeCountByTargetVertexAndEdgeLabel;
        this.distinctSourceVertexCount = distinctSourceVertexCount;
        this.distinctTargetVertexCount = distinctTargetVertexCount;
        this.distinctSourceVertexCountByEdgeLabel = distinctSourceVertexCountByEdgeLabel;
        this.distinctTargetVertexCountByEdgeLabel = distinctTargetVertexCountByEdgeLabel;
        this.distinctEdgePropertiesByLabel = distinctEdgePropertiesByLabel;
        this.distinctVertexPropertiesByLabel = distinctVertexPropertiesByLabel;
        this.distinctEdgeProperties = distinctEdgeProperties;
        this.distinctVertexProperties = distinctVertexProperties;
    }

    public long getVertexCount() {
        return this.vertexCount;
    }

    public long getEdgeCount() {
        return this.edgeCount;
    }

    public long getVertexCount(String vertexLabel) {
        return this.vertexCountByLabel.getOrDefault(vertexLabel, 0L);
    }

    public long getEdgeCount(String edgeLabel) {
        return this.edgeCountByLabel.getOrDefault(edgeLabel, 0L);
    }

    public long getEdgeCountBySource(String vertexLabel, String edgeLabel) {
        return this.edgeCountBySourceVertexAndEdgeLabel.containsKey(vertexLabel) ? this.edgeCountBySourceVertexAndEdgeLabel.get(vertexLabel).getOrDefault(edgeLabel, 0L) : 0L;
    }

    public long getEdgeCountByTarget(String vertexLabel, String edgeLabel) {
        return this.edgeCountByTargetVertexAndEdgeLabel.containsKey(vertexLabel) ? this.edgeCountByTargetVertexAndEdgeLabel.get(vertexLabel).getOrDefault(edgeLabel, 0L) : 0L;
    }

    public long getDistinctSourceVertexCount() {
        return this.distinctSourceVertexCount;
    }

    public long getDistinctTargetVertexCount() {
        return this.distinctTargetVertexCount;
    }

    public long getDistinctSourceVertexCount(String edgeLabel) {
        return this.distinctSourceVertexCountByEdgeLabel.getOrDefault(edgeLabel, 0L);
    }

    public long getDistinctTargetVertexCount(String edgeLabel) {
        return this.distinctTargetVertexCountByEdgeLabel.getOrDefault(edgeLabel, 0L);
    }

    public long getDistinctVertexProperties(String propertyName) {
        return this.distinctVertexProperties.getOrDefault(propertyName, 0L);
    }

    public long getDistinctEdgeProperties(String propertyName) {
        return this.distinctEdgeProperties.getOrDefault(propertyName, 0L);
    }

    public long getDistinctVertexProperties(String vertexLabel, String propertyName) {
        return this.distinctVertexPropertiesByLabel.containsKey(vertexLabel) ? this.distinctVertexPropertiesByLabel.get(vertexLabel).getOrDefault(propertyName, 0L) : 0L;
    }

    public long getDistinctEdgeProperties(String edgeLabel, String propertyName) {
        return this.distinctEdgePropertiesByLabel.containsKey(edgeLabel) ? this.distinctEdgePropertiesByLabel.get(edgeLabel).getOrDefault(propertyName, 0L) : 0L;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GraphStatistics{");
        sb.append(String.format("%n vertexCount=", new Object[0])).append(this.vertexCount);
        sb.append(String.format(",%n edgeCount=", new Object[0])).append(this.edgeCount);
        sb.append(String.format(",%n vertexCountByLabel=", new Object[0])).append(this.vertexCountByLabel);
        sb.append(String.format(",%n edgeCountByLabel=", new Object[0])).append(this.edgeCountByLabel);
        sb.append(String.format(",%n edgeCountByTargetVertexAndEdgeLabel=", new Object[0])).append(this.edgeCountByTargetVertexAndEdgeLabel);
        sb.append(String.format(",%n edgeCountBySourceVertexAndEdgeLabel=", new Object[0])).append(this.edgeCountBySourceVertexAndEdgeLabel);
        sb.append(String.format(",%n distinctSourceVertexCount=", new Object[0])).append(this.distinctSourceVertexCount);
        sb.append(String.format(",%n distinctTargetVertexCount=", new Object[0])).append(this.distinctTargetVertexCount);
        sb.append(String.format(",%n distinctSourceVertexCountByEdgeLabel=", new Object[0])).append(this.distinctSourceVertexCountByEdgeLabel);
        sb.append(String.format(",%n distinctTargetVertexCountByEdgeLabel=", new Object[0])).append(this.distinctTargetVertexCountByEdgeLabel);
        sb.append(String.format(",%n distinctVertexProperties=", new Object[0])).append(this.distinctVertexProperties);
        sb.append(String.format(",%n distinctEdgeProperties=", new Object[0])).append(this.distinctEdgeProperties);
        sb.append(String.format(",%n distinctVertexPropertiesByLabel=", new Object[0])).append(this.distinctVertexPropertiesByLabel);
        sb.append(String.format(",%n distinctEdgePropertiesByLabel=", new Object[0])).append(this.distinctEdgePropertiesByLabel);
        sb.append(String.format("%n}", new Object[0]));
        return sb.toString();
    }
}

