/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common.statistics;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.gradoop.flink.model.impl.operators.matching.common.statistics.GraphStatistics;
import org.gradoop.flink.model.impl.operators.matching.common.statistics.GraphStatisticsReader;

public class GraphStatisticsHDFSReader
extends GraphStatisticsReader {
    public static GraphStatistics read(String inputPath, Configuration configuration) throws IOException {
        Map<String, Long> distinctVertexPropertyValuesByPropertyName;
        Map<String, Long> distinctEdgePropertyValuesByPropertyName;
        Map<String, Map<String, Long>> distinctPropertyValuesByVertexLabelAndPropertyName;
        Map<String, Map<String, Long>> distinctPropertyValuesByEdgeLabelAndPropertyName;
        Map<String, Long> distinctTargetVertexCountByEdgeLabel;
        Map<String, Long> distinctSourceVertexCountByEdgeLabel;
        long distinctTargetVertexCount;
        long distinctSourceVertexCount;
        Map<String, Map<String, Long>> edgeCountByTargetVertexAndEdgeLabel;
        Map<String, Map<String, Long>> edgeCountBySourceVertexAndEdgeLabel;
        Map<String, Long> edgeCountByLabel;
        Map<String, Long> vertexCountByLabel;
        long edgeCount;
        long vertexCount;
        FileSystem fs = FileSystem.get((Configuration)configuration);
        Path root = new Path(inputPath);
        Charset charset = StandardCharsets.UTF_8;
        Path p = new Path(root, "vertex_count");
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(p), charset));){
            vertexCount = GraphStatisticsHDFSReader.readSingleValue(br.lines());
        }
        p = new Path(root, "edge_count");
        br = new BufferedReader(new InputStreamReader((InputStream)fs.open(p), charset));
        var25_7 = null;
        try {
            edgeCount = GraphStatisticsHDFSReader.readSingleValue(br.lines());
        }
        catch (Throwable throwable) {
            var25_7 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var25_7 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var25_7.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        p = new Path(root, "vertex_count_by_label");
        br = new BufferedReader(new InputStreamReader((InputStream)fs.open(p), charset));
        var25_7 = null;
        try {
            vertexCountByLabel = GraphStatisticsHDFSReader.readKeyValueMap(br.lines());
        }
        catch (Throwable throwable) {
            var25_7 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var25_7 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var25_7.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        p = new Path(root, "edge_count_by_label");
        br = new BufferedReader(new InputStreamReader((InputStream)fs.open(p), charset));
        var25_7 = null;
        try {
            edgeCountByLabel = GraphStatisticsHDFSReader.readKeyValueMap(br.lines());
        }
        catch (Throwable throwable) {
            var25_7 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var25_7 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var25_7.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        p = new Path(root, "edge_count_by_source_vertex_and_edge_label");
        br = new BufferedReader(new InputStreamReader((InputStream)fs.open(p), charset));
        var25_7 = null;
        try {
            edgeCountBySourceVertexAndEdgeLabel = GraphStatisticsHDFSReader.readNestedKeyValueMap(br.lines());
        }
        catch (Throwable throwable) {
            var25_7 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var25_7 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var25_7.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        p = new Path(root, "edge_count_by_target_vertex_and_edge_label");
        br = new BufferedReader(new InputStreamReader((InputStream)fs.open(p), charset));
        var25_7 = null;
        try {
            edgeCountByTargetVertexAndEdgeLabel = GraphStatisticsHDFSReader.readNestedKeyValueMap(br.lines());
        }
        catch (Throwable throwable) {
            var25_7 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var25_7 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var25_7.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        p = new Path(root, "distinct_source_vertex_count");
        br = new BufferedReader(new InputStreamReader((InputStream)fs.open(p), charset));
        var25_7 = null;
        try {
            distinctSourceVertexCount = GraphStatisticsHDFSReader.readSingleValue(br.lines());
        }
        catch (Throwable throwable) {
            var25_7 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var25_7 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var25_7.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        p = new Path(root, "distinct_target_vertex_count");
        br = new BufferedReader(new InputStreamReader((InputStream)fs.open(p), charset));
        var25_7 = null;
        try {
            distinctTargetVertexCount = GraphStatisticsHDFSReader.readSingleValue(br.lines());
        }
        catch (Throwable throwable) {
            var25_7 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var25_7 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var25_7.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        p = new Path(root, "distinct_source_vertex_count_by_edge_label");
        br = new BufferedReader(new InputStreamReader((InputStream)fs.open(p), charset));
        var25_7 = null;
        try {
            distinctSourceVertexCountByEdgeLabel = GraphStatisticsHDFSReader.readKeyValueMap(br.lines());
        }
        catch (Throwable throwable) {
            var25_7 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var25_7 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var25_7.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        p = new Path(root, "distinct_target_vertex_count_by_edge_label");
        br = new BufferedReader(new InputStreamReader((InputStream)fs.open(p), charset));
        var25_7 = null;
        try {
            distinctTargetVertexCountByEdgeLabel = GraphStatisticsHDFSReader.readKeyValueMap(br.lines());
        }
        catch (Throwable throwable) {
            var25_7 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var25_7 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var25_7.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        p = new Path(root, "distinct_edge_properties_by_label");
        br = new BufferedReader(new InputStreamReader((InputStream)fs.open(p), charset));
        var25_7 = null;
        try {
            distinctPropertyValuesByEdgeLabelAndPropertyName = GraphStatisticsHDFSReader.readNestedKeyValueMap(br.lines());
        }
        catch (Throwable throwable) {
            var25_7 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var25_7 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var25_7.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        p = new Path(root, "distinct_vertex_properties_by_label");
        br = new BufferedReader(new InputStreamReader((InputStream)fs.open(p), charset));
        var25_7 = null;
        try {
            distinctPropertyValuesByVertexLabelAndPropertyName = GraphStatisticsHDFSReader.readNestedKeyValueMap(br.lines());
        }
        catch (Throwable throwable) {
            var25_7 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var25_7 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var25_7.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        p = new Path(root, "distinct_edge_properties");
        br = new BufferedReader(new InputStreamReader((InputStream)fs.open(p), charset));
        var25_7 = null;
        try {
            distinctEdgePropertyValuesByPropertyName = GraphStatisticsHDFSReader.readKeyValueMap(br.lines());
        }
        catch (Throwable throwable) {
            var25_7 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var25_7 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var25_7.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        p = new Path(root, "distinct_vertex_properties");
        br = new BufferedReader(new InputStreamReader((InputStream)fs.open(p), charset));
        var25_7 = null;
        try {
            distinctVertexPropertyValuesByPropertyName = GraphStatisticsHDFSReader.readKeyValueMap(br.lines());
        }
        catch (Throwable throwable) {
            var25_7 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var25_7 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var25_7.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        return new GraphStatistics(vertexCount, edgeCount, vertexCountByLabel, edgeCountByLabel, edgeCountBySourceVertexAndEdgeLabel, edgeCountByTargetVertexAndEdgeLabel, distinctSourceVertexCount, distinctTargetVertexCount, distinctSourceVertexCountByEdgeLabel, distinctTargetVertexCountByEdgeLabel, distinctPropertyValuesByEdgeLabelAndPropertyName, distinctPropertyValuesByVertexLabelAndPropertyName, distinctEdgePropertyValuesByPropertyName, distinctVertexPropertyValuesByPropertyName);
    }
}

