/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common.statistics;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.gradoop.flink.model.impl.operators.matching.common.statistics.GraphStatistics;
import org.gradoop.flink.model.impl.operators.matching.common.statistics.GraphStatisticsReader;

public class GraphStatisticsLocalFSReader
extends GraphStatisticsReader {
    public static GraphStatistics read(String inputPath) throws IOException {
        Path statisticsDir = Paths.get(new File(inputPath).getAbsolutePath(), new String[0]);
        Charset charset = StandardCharsets.UTF_8;
        Path p = statisticsDir.resolve(Paths.get("vertex_count", new String[0]));
        long vertexCount = GraphStatisticsLocalFSReader.readSingleValue(Files.lines(p, charset));
        p = statisticsDir.resolve(Paths.get("edge_count", new String[0]));
        long edgeCount = GraphStatisticsLocalFSReader.readSingleValue(Files.lines(p, charset));
        p = statisticsDir.resolve(Paths.get("vertex_count_by_label", new String[0]));
        Map<String, Long> vertexCountByLabel = GraphStatisticsLocalFSReader.readKeyValueMap(Files.lines(p, charset));
        p = statisticsDir.resolve(Paths.get("edge_count_by_label", new String[0]));
        Map<String, Long> edgeCountByLabel = GraphStatisticsLocalFSReader.readKeyValueMap(Files.lines(p, charset));
        p = statisticsDir.resolve(Paths.get("edge_count_by_source_vertex_and_edge_label", new String[0]));
        Map<String, Map<String, Long>> edgeCountBySourceVertexAndEdgeLabel = GraphStatisticsLocalFSReader.readNestedKeyValueMap(Files.lines(p, charset));
        p = statisticsDir.resolve(Paths.get("edge_count_by_target_vertex_and_edge_label", new String[0]));
        Map<String, Map<String, Long>> edgeCountByTargetVertexAndEdgeLabel = GraphStatisticsLocalFSReader.readNestedKeyValueMap(Files.lines(p, charset));
        p = statisticsDir.resolve(Paths.get("distinct_source_vertex_count", new String[0]));
        long distinctSourceVertexCount = GraphStatisticsLocalFSReader.readSingleValue(Files.lines(p, charset));
        p = statisticsDir.resolve(Paths.get("distinct_target_vertex_count", new String[0]));
        long distinctTargetVertexCount = GraphStatisticsLocalFSReader.readSingleValue(Files.lines(p, charset));
        p = statisticsDir.resolve(Paths.get("distinct_source_vertex_count_by_edge_label", new String[0]));
        Map<String, Long> distSourceVertexCountByEdgeLabel = GraphStatisticsLocalFSReader.readKeyValueMap(Files.lines(p, charset));
        p = statisticsDir.resolve(Paths.get("distinct_target_vertex_count_by_edge_label", new String[0]));
        Map<String, Long> distTargetVertexCountByEdgeLabel = GraphStatisticsLocalFSReader.readKeyValueMap(Files.lines(p, charset));
        p = statisticsDir.resolve(Paths.get("distinct_edge_properties_by_label", new String[0]));
        Map<String, Map<String, Long>> distinctPropertyValuesByEdgeLabelAndPropertyName = GraphStatisticsLocalFSReader.readNestedKeyValueMap(Files.lines(p, charset));
        p = statisticsDir.resolve(Paths.get("distinct_vertex_properties_by_label", new String[0]));
        Map<String, Map<String, Long>> distinctPropertyValuesByVertexLabelAndPropertyName = GraphStatisticsLocalFSReader.readNestedKeyValueMap(Files.lines(p, charset));
        p = statisticsDir.resolve(Paths.get("distinct_edge_properties", new String[0]));
        Map<String, Long> distinctEdgePropertyValuesByPropertyName = GraphStatisticsLocalFSReader.readKeyValueMap(Files.lines(p, charset));
        p = statisticsDir.resolve(Paths.get("distinct_vertex_properties", new String[0]));
        Map<String, Long> distinctVertexPropertyValuesByPropertyName = GraphStatisticsLocalFSReader.readKeyValueMap(Files.lines(p, charset));
        return new GraphStatistics(vertexCount, edgeCount, vertexCountByLabel, edgeCountByLabel, edgeCountBySourceVertexAndEdgeLabel, edgeCountByTargetVertexAndEdgeLabel, distinctSourceVertexCount, distinctTargetVertexCount, distSourceVertexCountByEdgeLabel, distTargetVertexCountByEdgeLabel, distinctPropertyValuesByEdgeLabelAndPropertyName, distinctPropertyValuesByVertexLabelAndPropertyName, distinctEdgePropertyValuesByPropertyName, distinctVertexPropertyValuesByPropertyName);
    }
}

