/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.common.statistics;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class GraphStatisticsReader {
    public static final String TOKEN_SEPARATOR = ",";
    public static final String FILE_VERTEX_COUNT = "vertex_count";
    public static final String FILE_EDGE_COUNT = "edge_count";
    public static final String FILE_VERTEX_COUNT_BY_LABEL = "vertex_count_by_label";
    public static final String FILE_VERTEX_DEGREE_DISTRIBUTION = "vertex_degree_distribution";
    public static final String INCOMING_VERTEX_DEGREE_DISTRIBUTION = "incoming_vertex_degree_distribution";
    public static final String OUTGOING_VERTEX_DEGREE_DISTRIBUTION = "outgoing_vertex_degree_distribution";
    public static final String FILE_EDGE_COUNT_BY_LABEL = "edge_count_by_label";
    public static final String FILE_EDGE_COUNT_BY_SOURCE_VERTEX_AND_EDGE_LABEL = "edge_count_by_source_vertex_and_edge_label";
    public static final String FILE_EDGE_COUNT_BY_TARGET_VERTEX_AND_EDGE_LABEL = "edge_count_by_target_vertex_and_edge_label";
    public static final String FILE_DISTINCT_SOURCE_VERTEX_COUNT = "distinct_source_vertex_count";
    public static final String FILE_DISTINCT_TARGET_VERTEX_COUNT = "distinct_target_vertex_count";
    public static final String FILE_DISTINCT_SOURCE_VERTEX_COUNT_BY_EDGE_LABEL = "distinct_source_vertex_count_by_edge_label";
    public static final String FILE_DISTINCT_TARGET_VERTEX_COUNT_BY_EDGE_LABEL = "distinct_target_vertex_count_by_edge_label";
    public static final String FILE_DISTINCT_EDGE_PROPERTIES_BY_LABEL = "distinct_edge_properties_by_label";
    public static final String FILE_DISTINCT_VERTEX_PROPERTIES_BY_LABEL = "distinct_vertex_properties_by_label";
    public static final String FILE_DISTINCT_EDGE_PROPERTIES = "distinct_edge_properties";
    public static final String FILE_DISTINCT_VERTEX_PROPERTIES = "distinct_vertex_properties";

    static Long readSingleValue(Stream<String> lines) throws IOException {
        return (Long)lines.map(Long::parseLong).collect(Collectors.toList()).get(0);
    }

    static Map<String, Long> readKeyValueMap(Stream<String> lines) throws IOException {
        return lines.map(s -> s.split(TOKEN_SEPARATOR)).collect(Collectors.toMap(tokens -> tokens[0], tokens -> Long.parseLong(tokens[1])));
    }

    static Map<String, Map<String, Long>> readNestedKeyValueMap(Stream<String> lines) throws IOException {
        HashMap<String, Map<String, Long>> mapping = new HashMap<String, Map<String, Long>>();
        lines.map(line -> line.split(TOKEN_SEPARATOR)).forEach(tokens -> {
            String vertexLabel = tokens[0];
            String edgeLabel = tokens[1];
            Long edgeCount = Long.parseLong(tokens[2]);
            if (mapping.containsKey(vertexLabel)) {
                ((Map)mapping.get(vertexLabel)).put(edgeLabel, edgeCount);
            } else {
                HashMap<String, Long> value = new HashMap<String, Long>();
                value.put(edgeLabel, edgeCount);
                mapping.put(vertexLabel, value);
            }
        });
        return mapping;
    }
}

