/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.log4j.Logger;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.operators.UnaryBaseGraphToBaseGraphCollectionOperator;
import org.gradoop.flink.model.impl.functions.epgm.PairElementWithPropertyValue;
import org.gradoop.flink.model.impl.operators.matching.common.debug.PrintIdWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.common.debug.PrintTripleWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.common.query.QueryHandler;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.IdWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.TripleWithCandidates;

public abstract class PatternMatching<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
implements UnaryBaseGraphToBaseGraphCollectionOperator<LG, GC> {
    public static final transient String VARIABLE_MAPPING_KEY = "__variable_mapping";
    private final String query;
    private final Logger log;
    private final QueryHandler queryHandler;
    private final boolean attachData;
    private DataSet<Tuple2<GradoopId, PropertyValue>> vertexMapping;
    private DataSet<Tuple2<GradoopId, PropertyValue>> edgeMapping;

    public PatternMatching(String query, boolean attachData, Logger log) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)query) ? 1 : 0) != 0, (Object)"Query must not be null or empty");
        this.query = query;
        this.queryHandler = new QueryHandler(query);
        this.attachData = attachData;
        this.log = log;
    }

    @Override
    public GC execute(LG graph) {
        if (this.log.isDebugEnabled()) {
            this.initDebugMappings(graph);
        }
        GC result = this.queryHandler.isSingleVertexGraph() ? this.executeForVertex(graph) : this.executeForPattern(graph);
        return result;
    }

    protected abstract GC executeForVertex(LG var1);

    protected abstract GC executeForPattern(LG var1);

    protected QueryHandler getQueryHandler() {
        return this.queryHandler;
    }

    protected String getQuery() {
        return this.query;
    }

    protected boolean doAttachData() {
        return this.attachData;
    }

    protected DataSet<Tuple2<GradoopId, PropertyValue>> getVertexMapping() {
        return this.vertexMapping;
    }

    protected DataSet<Tuple2<GradoopId, PropertyValue>> getEdgeMapping() {
        return this.edgeMapping;
    }

    protected DataSet<TripleWithCandidates<GradoopId>> printTriplesWithCandidates(DataSet<TripleWithCandidates<GradoopId>> edges) {
        return ((MapOperator)edges.map(new PrintTripleWithCandidates()).withBroadcastSet(this.vertexMapping, "vertexMapping")).withBroadcastSet(this.edgeMapping, "edgeMapping");
    }

    protected DataSet<IdWithCandidates<GradoopId>> printIdWithCandidates(DataSet<IdWithCandidates<GradoopId>> vertices) {
        return ((MapOperator)vertices.map(new PrintIdWithCandidates()).withBroadcastSet(this.vertexMapping, "vertexMapping")).withBroadcastSet(this.edgeMapping, "edgeMapping");
    }

    private void initDebugMappings(LG graph) {
        this.vertexMapping = graph.getVertices().map(new PairElementWithPropertyValue("id"));
        this.edgeMapping = graph.getEdges().map(new PairElementWithPropertyValue("id"));
    }
}

