/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.log4j.Logger;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.impl.operators.matching.common.MatchStrategy;
import org.gradoop.flink.model.impl.operators.matching.common.PostProcessor;
import org.gradoop.flink.model.impl.operators.matching.common.debug.Printer;
import org.gradoop.flink.model.impl.operators.matching.common.query.QueryHandler;
import org.gradoop.flink.model.impl.operators.matching.common.statistics.GraphStatistics;
import org.gradoop.flink.model.impl.operators.matching.single.PatternMatching;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.debug.PrintEmbedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.functions.ElementsFromEmbedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.add.AddEmbeddingsElements;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.project.ProjectEmbeddingsElements;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.planner.greedy.GreedyPlanner;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.QueryPlan;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingMetaData;

public class CypherPatternMatching<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
extends PatternMatching<G, V, E, LG, GC> {
    private static final Logger LOG = Logger.getLogger(CypherPatternMatching.class);
    private final String constructionPattern;
    private final MatchStrategy vertexStrategy;
    private final MatchStrategy edgeStrategy;
    private final GraphStatistics graphStatistics;

    public CypherPatternMatching(String query, boolean attachData, MatchStrategy vertexStrategy, MatchStrategy edgeStrategy, GraphStatistics graphStatistics) {
        this(query, null, attachData, vertexStrategy, edgeStrategy, graphStatistics);
    }

    public CypherPatternMatching(String query, String constructionPattern, boolean attachData, MatchStrategy vertexStrategy, MatchStrategy edgeStrategy, GraphStatistics graphStatistics) {
        super(query, attachData, LOG);
        this.constructionPattern = constructionPattern;
        this.vertexStrategy = vertexStrategy;
        this.edgeStrategy = edgeStrategy;
        this.graphStatistics = graphStatistics;
    }

    @Override
    protected GC executeForVertex(LG graph) {
        return this.executeForPattern(graph);
    }

    @Override
    protected GC executeForPattern(LG graph) {
        QueryHandler queryHandler = this.getQueryHandler();
        QueryPlan plan = new GreedyPlanner(graph, queryHandler, this.graphStatistics, this.vertexStrategy, this.edgeStrategy).plan().getQueryPlan();
        DataSet<Embedding> embeddings = plan.execute();
        EmbeddingMetaData embeddingMetaData = plan.getRoot().getEmbeddingMetaData();
        embeddings = Printer.log(embeddings, new PrintEmbedding(embeddingMetaData), this.getVertexMapping(), this.getEdgeMapping());
        FlatMapOperator finalElements = this.constructionPattern != null ? this.constructFinalElements(graph, embeddings, embeddingMetaData) : embeddings.flatMap(new ElementsFromEmbedding(graph.getFactory().getGraphHeadFactory(), graph.getFactory().getVertexFactory(), graph.getFactory().getEdgeFactory(), embeddingMetaData, queryHandler.getSourceTargetVariables()));
        return this.doAttachData() ? PostProcessor.extractGraphCollectionWithData(finalElements, graph, true) : PostProcessor.extractGraphCollection(finalElements, graph.getCollectionFactory(), true);
    }

    private DataSet<Element> constructFinalElements(LG graph, DataSet<Embedding> embeddings, EmbeddingMetaData embeddingMetaData) {
        QueryHandler constructionPatternHandler = new QueryHandler(this.constructionPattern);
        constructionPatternHandler.updateGeneratedVariableNames(n -> "_" + n);
        HashSet queryVars = Sets.newHashSet(embeddingMetaData.getVariables());
        Set<String> constructionVars = constructionPatternHandler.getAllVariables();
        ImmutableSet existingVars = Sets.intersection((Set)queryVars, constructionVars).immutableCopy();
        ImmutableSet newVars = Sets.difference(constructionVars, (Set)queryVars).immutableCopy();
        EmbeddingMetaData newMetaData = this.computeNewMetaData(embeddingMetaData, constructionPatternHandler, (Set<String>)existingVars, (Set<String>)newVars);
        ProjectEmbeddingsElements projectedEmbeddings = new ProjectEmbeddingsElements(embeddings, (Set<String>)existingVars, embeddingMetaData, newMetaData);
        AddEmbeddingsElements addEmbeddingsElements = new AddEmbeddingsElements(projectedEmbeddings.evaluate(), newVars.size());
        return addEmbeddingsElements.evaluate().flatMap(new ElementsFromEmbedding(graph.getFactory().getGraphHeadFactory(), graph.getFactory().getVertexFactory(), graph.getFactory().getEdgeFactory(), newMetaData, constructionPatternHandler.getSourceTargetVariables(), constructionPatternHandler.getLabelsForVariables((Collection<String>)newVars)));
    }

    private EmbeddingMetaData computeNewMetaData(EmbeddingMetaData metaData, QueryHandler returnPatternHandler, Set<String> existingVariables, Set<String> newVariables) {
        EmbeddingMetaData newMetaData = new EmbeddingMetaData();
        for (String var : existingVariables) {
            newMetaData.setEntryColumn(var, metaData.getEntryType(var), newMetaData.getEntryCount());
        }
        for (String var : newVariables) {
            EmbeddingMetaData.EntryType type = returnPatternHandler.isEdge(var) ? EmbeddingMetaData.EntryType.EDGE : EmbeddingMetaData.EntryType.VERTEX;
            newMetaData.setEntryColumn(var, type, newMetaData.getEntryCount());
        }
        return newMetaData;
    }
}

