/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.debug;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.impl.operators.matching.common.debug.Printer;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingMetaData;

public class PrintEmbedding
extends Printer<Embedding, GradoopId> {
    private static final Logger LOG = Logger.getLogger(PrintEmbedding.class);
    private final EmbeddingMetaData embeddingMetaData;

    public PrintEmbedding(EmbeddingMetaData embeddingMetaData) {
        this.embeddingMetaData = embeddingMetaData;
    }

    @Override
    protected String getDebugString(Embedding embedding) {
        String vertexMapping = this.embeddingMetaData.getVertexVariables().stream().map(var -> String.format("%s : %s", var, this.vertexMap.get(embedding.getId(this.embeddingMetaData.getEntryColumn((String)var))))).collect(Collectors.joining(", "));
        String edgeMapping = this.embeddingMetaData.getEdgeVariables().stream().map(var -> String.format("%s : %s", var, this.edgeMap.get(embedding.getId(this.embeddingMetaData.getEntryColumn((String)var))))).collect(Collectors.joining(", "));
        String pathMapping = this.embeddingMetaData.getPathVariables().stream().map(var -> {
            List<GradoopId> path = embedding.getIdList(this.embeddingMetaData.getEntryColumn((String)var));
            ArrayList ids = new ArrayList();
            for (int i = 0; i < path.size(); ++i) {
                if (i % 2 == 0) {
                    ids.add(this.edgeMap.get(path.get(i)));
                    continue;
                }
                ids.add(this.vertexMap.get(path.get(i)));
            }
            return String.format("%s : %s", var, ids);
        }).collect(Collectors.joining(", "));
        return String.format("vertex-mapping: {%s}, edge-mapping: {%s}, path-mapping: {%s}", vertexMapping, edgeMapping, pathMapping);
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

