/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.functions;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.EdgeFactory;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.GraphHeadFactory;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.api.entities.VertexFactory;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingMetaData;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.utils.ExpandDirection;

public class ElementsFromEmbedding<G extends GraphHead, V extends Vertex, E extends Edge>
implements FlatMapFunction<Embedding, Element> {
    private final GraphHeadFactory<G> graphHeadFactory;
    private final VertexFactory<V> vertexFactory;
    private final EdgeFactory<E> edgeFactory;
    private final EmbeddingMetaData metaData;
    private final Map<String, Pair<String, String>> sourceTargetVariables;
    private final Map<PropertyValue, PropertyValue> variableMapping;
    private final Set<GradoopId> processedIds;
    private final Map<String, String> labelMapping;

    public ElementsFromEmbedding(GraphHeadFactory<G> graphHeadFactory, VertexFactory<V> vertexFactory, EdgeFactory<E> edgeFactory, EmbeddingMetaData embeddingMetaData, Map<String, Pair<String, String>> sourceTargetVariables) {
        this(graphHeadFactory, vertexFactory, edgeFactory, embeddingMetaData, sourceTargetVariables, Maps.newHashMapWithExpectedSize((int)0));
    }

    public ElementsFromEmbedding(GraphHeadFactory<G> graphHeadFactory, VertexFactory<V> vertexFactory, EdgeFactory<E> edgeFactory, EmbeddingMetaData embeddingMetaData, Map<String, Pair<String, String>> sourceTargetVariables, Map<String, String> labelMapping) {
        this.graphHeadFactory = graphHeadFactory;
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
        this.metaData = embeddingMetaData;
        this.sourceTargetVariables = sourceTargetVariables;
        this.labelMapping = labelMapping;
        this.variableMapping = new HashMap<PropertyValue, PropertyValue>(embeddingMetaData.getEntryCount());
        this.processedIds = new HashSet<GradoopId>(embeddingMetaData.getEntryCount());
    }

    public void flatMap(Embedding embedding, Collector<Element> out) throws Exception {
        GradoopId targetId;
        GradoopId sourceId;
        GradoopId edgeId;
        this.processedIds.clear();
        GraphHead graphHead = this.graphHeadFactory.createGraphHead();
        for (String vertexVariable : this.metaData.getVertexVariables()) {
            GradoopId id = embedding.getId(this.metaData.getEntryColumn(vertexVariable));
            if (this.labelMapping.containsKey(vertexVariable)) {
                String label = this.labelMapping.get(vertexVariable);
                this.initVertexWithData(out, graphHead, id, label);
            } else {
                this.initVertex(out, graphHead, id);
            }
            this.variableMapping.put(PropertyValue.create((Object)vertexVariable), PropertyValue.create((Object)id));
        }
        for (String edgeVariable : this.metaData.getEdgeVariables()) {
            edgeId = embedding.getId(this.metaData.getEntryColumn(edgeVariable));
            sourceId = embedding.getId(this.metaData.getEntryColumn((String)this.sourceTargetVariables.get(edgeVariable).getLeft()));
            targetId = embedding.getId(this.metaData.getEntryColumn((String)this.sourceTargetVariables.get(edgeVariable).getRight()));
            if (this.labelMapping.containsKey(edgeVariable)) {
                String label = this.labelMapping.get(edgeVariable);
                this.initEdgeWithData(out, graphHead, edgeId, sourceId, targetId, label);
            } else {
                this.initEdge(out, graphHead, edgeId, sourceId, targetId);
            }
            this.variableMapping.put(PropertyValue.create((Object)edgeVariable), PropertyValue.create((Object)edgeId));
        }
        for (String pathVariable : this.metaData.getPathVariables()) {
            ExpandDirection direction = this.metaData.getDirection(pathVariable);
            List<GradoopId> path = embedding.getIdList(this.metaData.getEntryColumn(pathVariable));
            ArrayList<PropertyValue> mappingValue = new ArrayList<PropertyValue>(path.size());
            for (int i = 0; i < path.size(); i += 2) {
                edgeId = path.get(i);
                mappingValue.add(PropertyValue.create((Object)edgeId));
                if (direction == ExpandDirection.OUT) {
                    sourceId = i > 0 ? path.get(i - 1) : embedding.getId(this.metaData.getEntryColumn((String)this.sourceTargetVariables.get(pathVariable).getLeft()));
                    GradoopId gradoopId = targetId = i < path.size() - 1 ? path.get(i + 1) : embedding.getId(this.metaData.getEntryColumn((String)this.sourceTargetVariables.get(pathVariable).getRight()));
                    if (i + 2 < path.size()) {
                        mappingValue.add(PropertyValue.create((Object)targetId));
                    }
                } else {
                    sourceId = i < path.size() - 1 ? path.get(i + 1) : embedding.getId(this.metaData.getEntryColumn((String)this.sourceTargetVariables.get(pathVariable).getLeft()));
                    GradoopId gradoopId = targetId = i > 0 ? path.get(i - 1) : embedding.getId(this.metaData.getEntryColumn((String)this.sourceTargetVariables.get(pathVariable).getRight()));
                    if (i > 0) {
                        mappingValue.add(PropertyValue.create((Object)sourceId));
                    }
                }
                this.initVertex(out, graphHead, sourceId);
                this.initVertex(out, graphHead, targetId);
                this.initEdge(out, graphHead, edgeId, sourceId, targetId);
            }
            this.variableMapping.put(PropertyValue.create((Object)pathVariable), PropertyValue.create(mappingValue));
        }
        graphHead.setProperty("__variable_mapping", this.variableMapping);
        out.collect((Object)graphHead);
    }

    private void initVertex(Collector<Element> out, G graphHead, GradoopId vertexId) {
        this.initVertexWithData(out, graphHead, vertexId, null);
    }

    private void initVertexWithData(Collector<Element> out, G graphHead, GradoopId vertexId, String label) {
        if (!this.processedIds.contains(vertexId)) {
            Vertex v = this.vertexFactory.initVertex(vertexId);
            v.addGraphId(graphHead.getId());
            v.setLabel(label);
            out.collect((Object)v);
            this.processedIds.add(vertexId);
        }
    }

    private void initEdge(Collector<Element> out, G graphHead, GradoopId edgeId, GradoopId sourceId, GradoopId targetId) {
        this.initEdgeWithData(out, graphHead, edgeId, sourceId, targetId, null);
    }

    private void initEdgeWithData(Collector<Element> out, G graphHead, GradoopId edgeId, GradoopId sourceId, GradoopId targetId, String label) {
        if (!this.processedIds.contains(edgeId)) {
            Edge e = this.edgeFactory.initEdge(edgeId, sourceId, targetId);
            e.addGraphId(graphHead.getId());
            e.setLabel(label);
            out.collect((Object)e);
            this.processedIds.add(edgeId);
        }
    }
}

