/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.expand;

import java.util.List;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.functions.ReverseEdgeEmbedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.PhysicalOperator;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.expand.functions.AdoptEmptyPaths;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.expand.functions.CreateExpandEmbedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.expand.functions.ExtractExpandColumn;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.expand.functions.ExtractKeyedCandidateEdges;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.expand.functions.PostProcessExpandEmbedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.expand.tuples.EdgeWithTiePoint;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.expand.tuples.ExpandEmbedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.utils.ExpandDirection;

public abstract class ExpandEmbeddings
implements PhysicalOperator {
    protected final DataSet<Embedding> input;
    protected final int expandColumn;
    protected final int lowerBound;
    protected final int upperBound;
    protected final ExpandDirection direction;
    protected final List<Integer> distinctVertexColumns;
    protected final List<Integer> distinctEdgeColumns;
    protected final int closingColumn;
    protected final JoinOperatorBase.JoinHint joinHint;
    protected DataSet<Embedding> candidateEdges;
    protected DataSet<EdgeWithTiePoint> candidateEdgeTuples;
    protected String name;

    public ExpandEmbeddings(DataSet<Embedding> input, DataSet<Embedding> candidateEdges, int expandColumn, int lowerBound, int upperBound, ExpandDirection direction, List<Integer> distinctVertexColumns, List<Integer> distinctEdgeColumns, int closingColumn, JoinOperatorBase.JoinHint joinHint) {
        this.input = input;
        this.candidateEdges = candidateEdges;
        this.expandColumn = expandColumn;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.direction = direction;
        this.distinctVertexColumns = distinctVertexColumns;
        this.distinctEdgeColumns = distinctEdgeColumns;
        this.closingColumn = closingColumn;
        this.joinHint = joinHint;
        this.setName("ExpandEmbeddings");
    }

    @Override
    public DataSet<Embedding> evaluate() {
        DataSet<ExpandEmbedding> initialWorkingSet = this.preProcess();
        DataSet<ExpandEmbedding> iterationResults = this.iterate(initialWorkingSet);
        return this.postProcess(iterationResults);
    }

    protected abstract DataSet<ExpandEmbedding> iterate(DataSet<ExpandEmbedding> var1);

    private DataSet<ExpandEmbedding> preProcess() {
        if (this.direction == ExpandDirection.IN) {
            this.candidateEdges = this.candidateEdges.map((MapFunction)new ReverseEdgeEmbedding()).name(this.getName() + " - Reverse Edges");
        }
        this.candidateEdgeTuples = ((MapOperator)this.candidateEdges.map((MapFunction)new ExtractKeyedCandidateEdges()).name(this.getName() + " - Create candidate edge tuples")).partitionByHash(new int[]{0}).name(this.getName() + " - Partition edge tuples");
        return this.input.join(this.candidateEdgeTuples, this.joinHint).where((KeySelector)new ExtractExpandColumn(this.expandColumn)).equalTo(new int[]{0}).with((FlatJoinFunction)new CreateExpandEmbedding(this.distinctVertexColumns, this.distinctEdgeColumns, this.closingColumn)).name(this.getName() + " - Initial expansion");
    }

    private DataSet<Embedding> postProcess(DataSet<ExpandEmbedding> iterationResults) {
        Operator results = iterationResults.flatMap((FlatMapFunction)new PostProcessExpandEmbedding(this.lowerBound, this.closingColumn)).name(this.getName() + " - Post Processing");
        if (this.lowerBound == 0) {
            results = results.union((DataSet)this.input.flatMap((FlatMapFunction)new AdoptEmptyPaths(this.expandColumn, this.closingColumn)).name(this.getName() + " - Append empty paths"));
        }
        return results;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

