/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.expand.functions;

import java.util.List;
import org.apache.flink.api.common.functions.RichFlatJoinFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.expand.tuples.EdgeWithTiePoint;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.expand.tuples.ExpandEmbedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;

@FunctionAnnotation.ReadFieldsSecond(value={"f1; f2"})
public class CreateExpandEmbedding
extends RichFlatJoinFunction<Embedding, EdgeWithTiePoint, ExpandEmbedding> {
    private final List<Integer> distinctVertices;
    private final List<Integer> distinctEdges;
    private final int closingColumn;

    public CreateExpandEmbedding(List<Integer> distinctVertices, List<Integer> distinctEdges, int closingColumn) {
        this.distinctVertices = distinctVertices;
        this.distinctEdges = distinctEdges;
        this.closingColumn = closingColumn;
    }

    public void join(Embedding input, EdgeWithTiePoint edge, Collector<ExpandEmbedding> out) throws Exception {
        if (this.checkDistinctiveness(input, edge)) {
            GradoopId[] path = new GradoopId[]{edge.getId(), edge.getTarget()};
            out.collect((Object)new ExpandEmbedding(input, path));
        }
    }

    private boolean checkDistinctiveness(Embedding input, EdgeWithTiePoint edge) {
        GradoopId edgeId = edge.getId();
        GradoopId tgt = edge.getTarget();
        for (int i : this.distinctVertices) {
            if (!input.getIdAsList(i).contains(tgt) || i == this.closingColumn) continue;
            return false;
        }
        for (int i : this.distinctEdges) {
            if (!input.getIdAsList(i).contains(edgeId)) continue;
            return false;
        }
        return true;
    }
}

